/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbListener;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.StudyBuild;
import gov.fcc.tvstudy.core.StudyBuildIxCheck;
import gov.fcc.tvstudy.core.StudyBuildTV6FM;
import gov.fcc.tvstudy.core.StudyBuildWireless;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.data.Template;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppFrame;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.DbController;
import gov.fcc.tvstudy.gui.EditMenu;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.ExtDbManager;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.OptionsPanel;
import gov.fcc.tvstudy.gui.OutputConfigDialog;
import gov.fcc.tvstudy.gui.RecordFind;
import gov.fcc.tvstudy.gui.StudyLockHolder;
import gov.fcc.tvstudy.gui.TemplateManager;
import gov.fcc.tvstudy.gui.editor.ColorMapEditor;
import gov.fcc.tvstudy.gui.editor.GeographyEditor;
import gov.fcc.tvstudy.gui.editor.ReceiveAntennaEditor;
import gov.fcc.tvstudy.gui.editor.StudyEditor;
import gov.fcc.tvstudy.gui.editor.TableFilterModel;
import gov.fcc.tvstudy.gui.editor.TableFilterPanel;
import gov.fcc.tvstudy.gui.run.AnalyzeRunResult;
import gov.fcc.tvstudy.gui.run.RunManager;
import gov.fcc.tvstudy.gui.run.RunPanel;
import gov.fcc.tvstudy.gui.run.RunPanelStudy;
import gov.fcc.tvstudy.gui.run.RunStart;
import gov.fcc.tvstudy.gui.run.RunStartPairStudy;
import gov.fcc.tvstudy.gui.run.RunStartStudy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;

public class StudyManager
extends AppFrame {
    public static final String WINDOW_TITLE = "Study Manager";
    private String dbID;
    private String dbName;
    private HashMap<Integer, StudyListItem> studyItemMap;
    private HashMap<Integer, StudyListItem> folderItemMap;
    private Integer currentFolderKey;
    private boolean showFolders;
    private StudyListTableModel studyListModel;
    private JTable studyListTable;
    private HashMap<Integer, StudyLockHolder> lockHolders;
    private JLabel freeSpaceLabel;
    private KeyedRecordMenu newStudyMenu;
    private JMenu moveToFolderMenu;
    private JMenuItem hideShowFoldersMenuItem;
    private JMenuItem newFolderMenuItem;
    private JMenuItem renameFolderMenuItem;
    private JMenuItem duplicateStudyMenuItem;
    private JMenuItem openStudyMenuItem;
    private JMenuItem deleteStudyMenuItem;
    private JMenuItem runStudyMenuItem;
    private JMenuItem analyzeStudyMenuItem;
    private JMenuItem pairStudyMenuItem;
    private JMenuItem clearCacheMenuItem;
    private JMenuItem unlockStudyMenuItem;
    private JMenuItem studyInfoMenuItem;
    private JMenuItem clearEditLockMenuItem;
    private JPopupMenu studyListTablePopupMenu;
    private JMenu cmMoveToFolderMenu;
    private JMenuItem cmDuplicateStudyMenuItem;
    private JMenuItem cmOpenStudyMenuItem;
    private JMenuItem cmAnalyzeStudyMenuItem;
    private JMenuItem cmDeleteStudyMenuItem;
    private JMenuItem cmRunStudyMenuItem;
    private JMenuItem cmStudyInfoMenuItem;
    private JButton openStudyButton;
    private JButton runStudyButton;
    private RecordFind stationDataViewer;
    private RecordFind studyBuildWizard;
    private static final int BUILD_BUTTON_ID = 1;
    private static final int BUILD_AND_RUN_BUTTON_ID = 2;
    private GeographyEditor geographyEditor;
    private ReceiveAntennaEditor receiveAntennaEditor;
    private boolean editLockSet;
    private ColorMapEditor colorMapEditor;
    private static final int TIMER_INTERVAL = 2000;
    private static final int UPDATE_INTERVAL = 60000;
    private static final int CACHE_CHECK_INTERVAL = 600000;
    private Timer updateTimer;
    private long lastListUpdate;
    private Thread updateThread;
    private ArrayDeque<StudyListItem> updateItems;
    private ArrayDeque<StudyListItem> updatedItems;
    private boolean holdStudyLocks;
    private StudyManager outerThis = this;
    private static HashMap<String, StudyManager> managers = new HashMap();

    public static boolean showManager(String string) {
        StudyManager studyManager = managers.get(string);
        if (null != studyManager) {
            studyManager.toFront();
            return true;
        }
        if (DbCore.isDbRegistered((String)string)) {
            studyManager = new StudyManager(string);
            managers.put(string, studyManager);
            AppController.showWindow(studyManager);
            return true;
        }
        return false;
    }

    private StudyManager(String string) {
        super(null, WINDOW_TITLE);
        this.dbID = string;
        this.studyItemMap = new HashMap();
        this.folderItemMap = new HashMap();
        this.currentFolderKey = 0;
        this.showFolders = true;
        this.studyListModel = new StudyListTableModel();
        this.studyListTable = this.studyListModel.createTable(this.editMenu);
        this.studyListTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    StudyManager.this.doOpenItem(null);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StudyManager.this.studyListTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StudyManager.this.studyListTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.studyListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StudyManager.this.updateControls();
            }
        });
        String string2 = AppCore.getPreference((String)"studyManagerNameColumnFirst");
        if (null == string2 || !Boolean.valueOf(string2).booleanValue()) {
            this.studyListTable.moveColumn(0, 1);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Studies"));
        jPanel.add((Component)AppController.createScrollPane(this.studyListTable), "Center");
        jPanel.add((Component)this.studyListModel.filterPanel, "South");
        this.lockHolders = new HashMap();
        this.freeSpaceLabel = new JLabel("Available disk space XXXXXXXX");
        this.updateTimer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doUpdates();
            }
        });
        this.updateItems = new ArrayDeque();
        this.updatedItems = new ArrayDeque();
        this.newStudyMenu = new KeyedRecordMenu();
        this.newStudyMenu.addItem(new KeyedRecord(0, "New Study..."));
        this.newStudyMenu.addItem(new KeyedRecord(1, Study.getStudyTypeName((int)1)));
        this.newStudyMenu.addItem(new KeyedRecord(-2, Study.getStudyTypeName((int)2)));
        this.newStudyMenu.addItem(new KeyedRecord(2, Study.getStudyTypeName((int)2) + " (advanced)"));
        this.newStudyMenu.addItem(new KeyedRecord(-3, Study.getStudyTypeName((int)3)));
        this.newStudyMenu.addItem(new KeyedRecord(3, Study.getStudyTypeName((int)3) + " (advanced)"));
        this.newStudyMenu.addItem(new KeyedRecord(4, Study.getStudyTypeName((int)4)));
        this.newStudyMenu.addItem(new KeyedRecord(-5, Study.getStudyTypeName((int)5)));
        this.newStudyMenu.addItem(new KeyedRecord(5, Study.getStudyTypeName((int)5) + " (advanced)"));
        this.newStudyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StudyManager.this.blockActions()) {
                    int n = StudyManager.this.newStudyMenu.getSelectedKey();
                    StudyManager.this.newStudyMenu.setSelectedIndex(0);
                    StudyManager.this.blockActionsEnd();
                    if (n > 0) {
                        StudyManager.this.doCreateNewStudy(n);
                    } else if (n < 0) {
                        StudyManager.this.doRunNewStudy(-n);
                    }
                }
            }
        });
        this.openStudyButton = new JButton("Open");
        this.openStudyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doOpenItem(null);
            }
        });
        this.runStudyButton = new JButton("Run");
        this.runStudyButton.setFocusable(false);
        this.runStudyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doRunStudy(false);
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.newStudyMenu);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.freeSpaceLabel);
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        jPanel4.add(this.runStudyButton);
        jPanel4.add(this.openStudyButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel5, "South");
        this.getRootPane().setDefaultButton(this.openStudyButton);
        this.pack();
        Dimension dimension = new Dimension(790, 500);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.fileMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Previous");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doPrevious();
            }
        });
        this.fileMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Next");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doNext();
            }
        });
        this.fileMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Down");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(39, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doOpenItem(null);
            }
        });
        this.fileMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Back");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(37, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doBack();
            }
        });
        this.fileMenu.add(jMenuItem4);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem("Refresh List");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.updateStudyList(false, true, false);
            }
        });
        this.fileMenu.add(jMenuItem5);
        this.fileMenu.addSeparator();
        this.hideShowFoldersMenuItem = new JMenuItem("Hide Folders");
        this.hideShowFoldersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StudyManager.this.showFolders) {
                    StudyManager.this.hideShowFoldersMenuItem.setText("Show Folders");
                    StudyManager.this.showFolders = false;
                } else {
                    StudyManager.this.hideShowFoldersMenuItem.setText("Hide Folders");
                    StudyManager.this.showFolders = true;
                }
                StudyManager.this.updateStudyList(false, false, true);
            }
        });
        this.fileMenu.add(this.hideShowFoldersMenuItem);
        this.newFolderMenuItem = new JMenuItem("New Folder...");
        this.newFolderMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, AppController.MENU_SHORTCUT_KEY_MASK));
        this.newFolderMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doCreateFolder();
            }
        });
        this.fileMenu.add(this.newFolderMenuItem);
        this.renameFolderMenuItem = new JMenuItem("Rename Folder...");
        this.renameFolderMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doRenameFolder();
            }
        });
        this.fileMenu.add(this.renameFolderMenuItem);
        this.moveToFolderMenu = new JMenu("Move To Folder");
        this.fileMenu.add(this.moveToFolderMenu);
        this.fileMenu.addSeparator();
        JMenu jMenu = new JMenu("New Study");
        JMenuItem jMenuItem6 = new JMenuItem(Study.getStudyTypeName((int)1));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doCreateNewStudy(1);
            }
        });
        jMenu.add(jMenuItem6);
        jMenuItem6 = new JMenuItem(Study.getStudyTypeName((int)2));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doRunNewStudy(2);
            }
        });
        jMenu.add(jMenuItem6);
        jMenuItem6 = new JMenuItem(Study.getStudyTypeName((int)2) + " (advanced)");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doCreateNewStudy(2);
            }
        });
        jMenu.add(jMenuItem6);
        jMenuItem6 = new JMenuItem(Study.getStudyTypeName((int)3));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doRunNewStudy(3);
            }
        });
        jMenu.add(jMenuItem6);
        jMenuItem6 = new JMenuItem(Study.getStudyTypeName((int)3) + " (advanced)");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doCreateNewStudy(3);
            }
        });
        jMenu.add(jMenuItem6);
        jMenuItem6 = new JMenuItem(Study.getStudyTypeName((int)4));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doCreateNewStudy(4);
            }
        });
        jMenu.add(jMenuItem6);
        jMenuItem6 = new JMenuItem(Study.getStudyTypeName((int)5));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doRunNewStudy(5);
            }
        });
        jMenu.add(jMenuItem6);
        jMenuItem6 = new JMenuItem(Study.getStudyTypeName((int)5) + " (advanced)");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doCreateNewStudy(5);
            }
        });
        jMenu.add(jMenuItem6);
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.duplicateStudyMenuItem = new JMenuItem("Duplicate...");
        this.duplicateStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doDuplicateStudy();
            }
        });
        this.fileMenu.add(this.duplicateStudyMenuItem);
        this.openStudyMenuItem = new JMenuItem("Open");
        this.openStudyMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppController.MENU_SHORTCUT_KEY_MASK));
        this.openStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doOpenItem(null);
            }
        });
        this.fileMenu.add(this.openStudyMenuItem);
        string2 = AppCore.getPreference((String)"showCreateResultTables");
        if (null != string2 && Boolean.valueOf(string2).booleanValue()) {
            this.analyzeStudyMenuItem = new JMenuItem("Analyze Result");
            this.analyzeStudyMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyManager.this.doAnalyzeStudy();
                }
            });
            this.fileMenu.add(this.analyzeStudyMenuItem);
        }
        this.deleteStudyMenuItem = new JMenuItem("Delete");
        this.deleteStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doDeleteItem();
            }
        });
        this.fileMenu.add(this.deleteStudyMenuItem);
        this.fileMenu.addSeparator();
        this.runStudyMenuItem = new JMenuItem("Run...");
        this.runStudyMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, AppController.MENU_SHORTCUT_KEY_MASK));
        this.runStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doRunStudy(false);
            }
        });
        this.fileMenu.add(this.runStudyMenuItem);
        this.pairStudyMenuItem = new JMenuItem("Run Pair Study...");
        this.pairStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doRunStudy(true);
            }
        });
        this.fileMenu.add(this.pairStudyMenuItem);
        this.fileMenu.addSeparator();
        this.clearCacheMenuItem = new JMenuItem("Clear Cache");
        this.clearCacheMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doClearCache();
            }
        });
        this.fileMenu.add(this.clearCacheMenuItem);
        this.unlockStudyMenuItem = new JMenuItem("Unlock");
        this.unlockStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doUnlockStudy();
            }
        });
        this.fileMenu.add(this.unlockStudyMenuItem);
        this.fileMenu.addSeparator();
        this.studyInfoMenuItem = new JMenuItem("Get Info");
        this.studyInfoMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, AppController.MENU_SHORTCUT_KEY_MASK));
        this.studyInfoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doStudyInfo();
            }
        });
        this.fileMenu.add(this.studyInfoMenuItem);
        this.studyListTablePopupMenu = new JPopupMenu();
        this.cmMoveToFolderMenu = new JMenu("Move To Folder");
        this.studyListTablePopupMenu.add(this.cmMoveToFolderMenu);
        this.cmOpenStudyMenuItem = new JMenuItem("Open");
        this.cmOpenStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doOpenItem(null);
            }
        });
        this.studyListTablePopupMenu.add(this.cmOpenStudyMenuItem);
        if (null != this.analyzeStudyMenuItem) {
            this.cmAnalyzeStudyMenuItem = new JMenuItem("Analyze");
            this.cmAnalyzeStudyMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyManager.this.doAnalyzeStudy();
                }
            });
            this.studyListTablePopupMenu.add(this.cmAnalyzeStudyMenuItem);
        }
        this.cmRunStudyMenuItem = new JMenuItem("Run...");
        this.cmRunStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doRunStudy(false);
            }
        });
        this.studyListTablePopupMenu.add(this.cmRunStudyMenuItem);
        this.cmDuplicateStudyMenuItem = new JMenuItem("Duplicate...");
        this.cmDuplicateStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doDuplicateStudy();
            }
        });
        this.studyListTablePopupMenu.add(this.cmDuplicateStudyMenuItem);
        this.cmDeleteStudyMenuItem = new JMenuItem("Delete");
        this.cmDeleteStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doDeleteItem();
            }
        });
        this.studyListTablePopupMenu.add(this.cmDeleteStudyMenuItem);
        this.cmStudyInfoMenuItem = new JMenuItem("Get Info");
        this.cmStudyInfoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doStudyInfo();
            }
        });
        this.studyListTablePopupMenu.add(this.cmStudyInfoMenuItem);
        this.extraMenu.removeAll();
        JMenuItem jMenuItem7 = new JMenuItem("View Station Data");
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(68, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doShowStationDataViewer();
            }
        });
        this.extraMenu.add(jMenuItem7);
        this.extraMenu.addSeparator();
        JMenuItem jMenuItem8 = new JMenuItem("Station Data Manager");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbManager.showManager(StudyManager.this.dbID);
            }
        });
        this.extraMenu.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Template Manager");
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateManager.showManager(StudyManager.this.dbID);
            }
        });
        this.extraMenu.add(jMenuItem9);
        this.extraMenu.addSeparator();
        JMenuItem jMenuItem10 = new JMenuItem("Geography Editor");
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.showGeographyEditor(StudyManager.this.dbID, 0, "", 0, "", 1, 0);
            }
        });
        this.extraMenu.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem("Receive Antenna Editor");
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.showReceiveAntennaEditor(StudyManager.this.dbID);
            }
        });
        this.extraMenu.add(jMenuItem11);
        this.clearEditLockMenuItem = new JMenuItem("Clear Edit Lock");
        this.clearEditLockMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doClearEditLock();
            }
        });
        this.extraMenu.add(this.clearEditLockMenuItem);
        this.extraMenu.addSeparator();
        JMenuItem jMenuItem12 = new JMenuItem("Output Settings...");
        jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppController.showWindow(new OutputConfigDialog(StudyManager.this.outerThis));
            }
        });
        this.extraMenu.add(jMenuItem12);
        if (AppCore.showImageOptions) {
            JMenuItem jMenuItem13 = new JMenuItem("Image Color Maps...");
            jMenuItem13.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyManager.this.showColorMapEditor();
                }
            });
            this.extraMenu.add(jMenuItem13);
        }
        this.updateControls();
        this.updateDocumentName();
        this.updateFreeSpace();
    }

    private void updateControls() {
        int n = this.studyListTable.getSelectedRowCount();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        if (1 == n) {
            StudyListItem studyListItem = this.studyListModel.get(this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow()));
            StudyLockHolder studyLockHolder = null;
            if (!studyListItem.isFolder) {
                studyLockHolder = this.lockHolders.get(studyListItem.key);
            }
            if (null != studyLockHolder) {
                bl = true;
                bl3 = true;
                if (1 == studyLockHolder.getStudyLock()) {
                    bl5 = true;
                    bl9 = true;
                }
                bl11 = true;
            } else if (studyListItem.isFolder) {
                if (studyListItem.isLink) {
                    bl3 = true;
                } else {
                    bl = true;
                    bl2 = true;
                    bl3 = true;
                    bl5 = 0 == studyListItem.items.size();
                }
            } else {
                bl = true;
                bl3 = true;
                bl4 = true;
                bl5 = true;
                bl6 = AppCore.maxEngineProcessCount > 0;
                bl7 = bl6 && 1 == studyListItem.studyType;
                bl8 = studyListItem.hasResultTables;
                bl9 = true;
                bl10 = 0 != studyListItem.studyLock;
                bl11 = true;
            }
        } else if (n > 1) {
            bl = true;
            bl5 = true;
            bl9 = true;
        }
        this.moveToFolderMenu.setEnabled(bl && this.showFolders);
        this.cmMoveToFolderMenu.setEnabled(bl && this.showFolders);
        this.newFolderMenuItem.setEnabled(this.showFolders);
        this.renameFolderMenuItem.setEnabled(bl2);
        this.openStudyMenuItem.setEnabled(bl3);
        this.cmOpenStudyMenuItem.setEnabled(bl3);
        this.openStudyButton.setEnabled(bl3);
        this.duplicateStudyMenuItem.setEnabled(bl4);
        this.cmDuplicateStudyMenuItem.setEnabled(bl4);
        this.deleteStudyMenuItem.setEnabled(bl5);
        this.cmDeleteStudyMenuItem.setEnabled(bl5);
        this.runStudyMenuItem.setEnabled(bl6);
        this.cmRunStudyMenuItem.setEnabled(bl6);
        this.runStudyButton.setEnabled(bl6);
        this.pairStudyMenuItem.setEnabled(bl7);
        if (null != this.analyzeStudyMenuItem) {
            this.analyzeStudyMenuItem.setEnabled(bl8);
            this.cmAnalyzeStudyMenuItem.setEnabled(bl8);
        }
        this.clearCacheMenuItem.setEnabled(bl9);
        this.unlockStudyMenuItem.setEnabled(bl10);
        this.studyInfoMenuItem.setEnabled(bl11);
        this.cmStudyInfoMenuItem.setEnabled(bl11);
    }

    @Override
    public String getDbID() {
        return this.dbID;
    }

    @Override
    protected String getFileMenuName() {
        return "Study";
    }

    @Override
    protected boolean showsExtraMenu() {
        return true;
    }

    @Override
    protected String getExtraMenuName() {
        return "Database";
    }

    @Override
    public void updateDocumentName() {
        this.dbName = DbCore.getHostDbName((String)this.dbID);
        StudyListItem studyListItem = this.folderItemMap.get(this.currentFolderKey);
        if (null != studyListItem && studyListItem.folderKey != 0) {
            if (studyListItem.parentFolderKey != 0) {
                if (null == this.dbName) {
                    this.setDocumentName(".../" + studyListItem.name);
                } else {
                    this.setDocumentName(this.dbName + "/.../" + studyListItem.name);
                }
            } else if (null == this.dbName) {
                this.setDocumentName(studyListItem.name);
            } else {
                this.setDocumentName(this.dbName + "/" + studyListItem.name);
            }
        } else {
            this.setDocumentName(this.dbName);
        }
        if (null != this.geographyEditor) {
            this.geographyEditor.updateDocumentName();
        }
        if (null != this.receiveAntennaEditor) {
            this.receiveAntennaEditor.updateDocumentName();
        }
        if (null != this.colorMapEditor) {
            this.colorMapEditor.updateDocumentName();
        }
        if (null != this.stationDataViewer) {
            this.stationDataViewer.updateDocumentName();
        }
        if (null != this.studyBuildWizard) {
            this.studyBuildWizard.updateDocumentName();
        }
    }

    @Override
    public String getDocumentName() {
        return this.dbName;
    }

    public static boolean showGeographyEditor(String string, int n, String string2, int n2, String string3, int n3, int n4) {
        StudyManager studyManager = managers.get(string);
        if (null == studyManager) {
            return false;
        }
        if (null != studyManager.geographyEditor && studyManager.geographyEditor.isVisible()) {
            studyManager.geographyEditor.toFront();
            return studyManager.geographyEditor.setScope(n, string2, n2, string3, n3, n4);
        }
        if (!studyManager.acquireEditLock()) {
            return false;
        }
        if (null == studyManager.geographyEditor) {
            studyManager.geographyEditor = new GeographyEditor(studyManager);
        }
        studyManager.geographyEditor.setScope(n, string2, n2, string3, n3, n4);
        AppController.showWindow(studyManager.geographyEditor);
        return true;
    }

    public static void updateGeographyEditor(String string, int n, String string2, int n2, String string3) {
        StudyManager studyManager = managers.get(string);
        if (null != studyManager && null != studyManager.geographyEditor) {
            studyManager.geographyEditor.updateScope(n, string2, n2, string3);
        }
    }

    public static boolean isGeographyInUse(String string, int n) {
        StudyManager studyManager = managers.get(string);
        if (null == studyManager) {
            return false;
        }
        for (StudyLockHolder studyLockHolder : studyManager.lockHolders.values()) {
            if (!(studyLockHolder instanceof StudyEditor) || !((StudyEditor)studyLockHolder).isGeographyInUse(n)) continue;
            return true;
        }
        return false;
    }

    public static void geographyChanged(String string, int n, int n2, Integer n3, int n4) {
        StudyManager studyManager = managers.get(string);
        if (null == studyManager) {
            return;
        }
        for (StudyLockHolder studyLockHolder : studyManager.lockHolders.values()) {
            if (!(studyLockHolder instanceof StudyEditor)) continue;
            ((StudyEditor)studyLockHolder).geographyChanged(n, n2, n3, n4);
        }
    }

    public static void geographyScopeChanged(String string, int n, int n2) {
        StudyManager studyManager = managers.get(string);
        if (null == studyManager) {
            return;
        }
        for (StudyLockHolder studyLockHolder : studyManager.lockHolders.values()) {
            if (!(studyLockHolder instanceof StudyEditor)) continue;
            ((StudyEditor)studyLockHolder).geographyScopeChanged(n, n2);
        }
    }

    public static boolean closeGeographyScopeIfPossible(String string, int n, int n2) {
        StudyManager studyManager = managers.get(string);
        if (null == studyManager) {
            return true;
        }
        if (null != studyManager.geographyEditor && studyManager.geographyEditor.isVisible()) {
            return studyManager.geographyEditor.closeScopeIfPossible(n, n2);
        }
        return true;
    }

    public static boolean closeGeographyScopeWithoutSave(String string, int n, int n2) {
        StudyManager studyManager = managers.get(string);
        if (null == studyManager) {
            return true;
        }
        if (null != studyManager.geographyEditor && studyManager.geographyEditor.isVisible()) {
            return studyManager.geographyEditor.closeScopeWithoutSave(n, n2);
        }
        return true;
    }

    public static boolean showReceiveAntennaEditor(String string) {
        StudyManager studyManager = managers.get(string);
        if (null == studyManager) {
            return false;
        }
        if (null != studyManager.receiveAntennaEditor && studyManager.receiveAntennaEditor.isVisible()) {
            studyManager.receiveAntennaEditor.toFront();
            return true;
        }
        if (!studyManager.acquireEditLock()) {
            return false;
        }
        if (null == studyManager.receiveAntennaEditor) {
            studyManager.receiveAntennaEditor = new ReceiveAntennaEditor(studyManager);
        }
        AppController.showWindow(studyManager.receiveAntennaEditor);
        return true;
    }

    public static boolean isReceiveAntennaInUse(String string, int n) {
        StudyManager studyManager = managers.get(string);
        if (null == studyManager) {
            return false;
        }
        if (null != studyManager.geographyEditor) {
            return studyManager.geographyEditor.isReceiveAntennaInUse(n);
        }
        return false;
    }

    public static void updateReceiveAntennas(String string) {
        StudyManager studyManager = managers.get(string);
        if (null == studyManager) {
            return;
        }
        if (null != studyManager.geographyEditor) {
            studyManager.geographyEditor.updateReceiveAntennas();
        }
    }

    private boolean acquireEditLock() {
        if (this.editLockSet) {
            return true;
        }
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)this.errorReporter);
        if (null == dbConnection) {
            return false;
        }
        String string = null;
        try {
            dbConnection.update("LOCK TABLES edit_lock WRITE");
            dbConnection.query("SELECT locked FROM edit_lock");
            dbConnection.next();
            if (!dbConnection.getBoolean(1)) {
                dbConnection.update("UPDATE edit_lock SET locked = true");
                this.editLockSet = true;
            }
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError((SQLException)sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError((SQLException)sQLException);
        }
        DbCore.releaseDb((DbConnection)dbConnection);
        if (null != string) {
            this.errorReporter.reportError(string);
            return false;
        }
        if (!this.editLockSet) {
            this.errorReporter.reportWarning("Another application is currently editing geographies or\nreceive antennas in this database, please try again later");
            return false;
        }
        this.clearEditLockMenuItem.setEnabled(false);
        return true;
    }

    private void clearEditLock() {
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID);
        if (null != dbConnection) {
            try {
                dbConnection.update("UPDATE edit_lock SET locked = false");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError((SQLException)sQLException);
            }
            DbCore.releaseDb((DbConnection)dbConnection);
        }
        this.editLockSet = false;
        this.clearEditLockMenuItem.setEnabled(true);
    }

    private void doClearEditLock() {
        if (this.editLockSet) {
            return;
        }
        String string = "Clear Edit Lock";
        this.errorReporter.setTitle(string);
        AppController.beep();
        if (0 != JOptionPane.showConfirmDialog(this, "This will clear the editing lock for geography data and receive antennas.\nDo this only if the lock was not cleared due to an application crash or\nnetwork failure.  If this is done while another application is still\nediting the data, studies may be corrupted and future runs may fail.\n\nDo you want to continue?", string, 0, 2)) {
            return;
        }
        this.clearEditLock();
    }

    private void showColorMapEditor() {
        if (null == this.colorMapEditor) {
            this.colorMapEditor = new ColorMapEditor(this.outerThis);
        } else if (this.colorMapEditor.isVisible()) {
            this.colorMapEditor.toFront();
            return;
        }
        AppController.showWindow(this.colorMapEditor);
    }

    private void doUpdates() {
        this.updateFreeSpace();
        if (System.currentTimeMillis() - this.lastListUpdate > 60000L) {
            this.updateStudyList(true, true, false);
        } else {
            StudyListItem studyListItem;
            do {
                if (null == (studyListItem = this.getUpdatedItem())) continue;
                this.studyListModel.itemWasChanged(studyListItem);
            } while (studyListItem != null);
        }
        if (this.isUpdateItemsEmpty() || null != this.updateThread && this.updateThread.isAlive()) {
            return;
        }
        this.updateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StudyListItem studyListItem;
                do {
                    if (null == (studyListItem = StudyManager.this.getUpdateItem()) || !studyListItem.isCacheSizeExpired()) continue;
                    studyListItem.updateCacheSize();
                    StudyManager.this.addUpdatedItem(studyListItem);
                } while (null != studyListItem);
            }
        });
        this.updateThread.start();
    }

    private synchronized void addUpdateItem(StudyListItem studyListItem) {
        this.updateItems.add(studyListItem);
    }

    private synchronized StudyListItem getUpdateItem() {
        return this.updateItems.poll();
    }

    private synchronized boolean isUpdateItemsEmpty() {
        return this.updateItems.isEmpty();
    }

    private synchronized void clearUpdateItems() {
        this.updateItems.clear();
    }

    private synchronized void addUpdatedItem(StudyListItem studyListItem) {
        this.updatedItems.add(studyListItem);
    }

    private synchronized StudyListItem getUpdatedItem() {
        return this.updatedItems.poll();
    }

    private synchronized void clearUpdatedItems() {
        this.updatedItems.clear();
    }

    public static void updateCacheSizes() {
        for (StudyManager studyManager : managers.values()) {
            for (StudyListItem studyListItem : studyManager.studyItemMap.values()) {
                studyListItem.clearCacheSize();
            }
            studyManager.updateStudyList(true, true, false);
        }
    }

    private void updateStudyList(boolean bl, boolean bl2, boolean bl3) {
        int n;
        String string = "Load Study List";
        String string2 = null;
        ErrorReporter errorReporter = null;
        if (!bl) {
            string2 = this.errorReporter.getTitle();
            this.errorReporter.setTitle(string);
            errorReporter = this.errorReporter;
        }
        ArrayList<StudyListItem> arrayList = this.getItems(errorReporter);
        this.lastListUpdate = System.currentTimeMillis();
        if (null == arrayList) {
            if (null != string2) {
                this.errorReporter.setTitle(string2);
            }
            return;
        }
        int[] nArray = null;
        HashSet<StudyListItem> hashSet = null;
        if (bl2 && this.studyListTable.getSelectedRowCount() > 0) {
            nArray = this.studyListTable.getSelectedRows();
            hashSet = new HashSet<StudyListItem>(nArray.length);
            for (n = 0; n < nArray.length; ++n) {
                hashSet.add(this.studyListModel.get(this.studyListTable.convertRowIndexToModel(nArray[n])));
            }
        }
        this.studyListTable.clearSelection();
        this.studyListModel.setItems(arrayList, bl3);
        if (hashSet != null) {
            int n2;
            n = 0;
            for (StudyListItem studyListItem : hashSet) {
                n2 = this.studyListModel.indexOf(studyListItem);
                if (n2 < 0) continue;
                nArray[n++] = this.studyListTable.convertRowIndexToView(n2);
            }
            if (n > 0) {
                int n3;
                for (n2 = 0; n2 < n - 1; ++n2) {
                    n3 = n2;
                    for (int i = n2 + 1; i < n; ++i) {
                        if (nArray[i] >= nArray[n3]) continue;
                        n3 = i;
                    }
                    if (n3 == n2) continue;
                    int n4 = nArray[n2];
                    nArray[n2] = nArray[n3];
                    nArray[n3] = n4;
                }
                n3 = nArray[0];
                for (n2 = 1; n2 < n; ++n2) {
                    if (nArray[n2] <= nArray[n2 - 1] + 1) continue;
                    this.studyListTable.addRowSelectionInterval(n3, nArray[n2 - 1]);
                    n3 = nArray[n2];
                }
                this.studyListTable.addRowSelectionInterval(n3, nArray[n - 1]);
            }
        }
        this.updateControls();
        if (null != string2) {
            this.errorReporter.setTitle(string2);
        }
    }

    private void updateFreeSpace() {
        AppCore.FreeSpaceInfo freeSpaceInfo = AppCore.getFreeSpace((String)this.dbID);
        if (freeSpaceInfo.sameFileStore) {
            this.freeSpaceLabel.setText("Available disk space " + AppCore.formatBytes((long)freeSpaceInfo.totalFreeSpace));
        } else {
            this.freeSpaceLabel.setText("Available disk space " + AppCore.formatBytes((long)freeSpaceInfo.totalFreeSpace) + " (cache " + AppCore.formatBytes((long)freeSpaceInfo.cacheFreeSpace) + ", output " + AppCore.formatBytes((long)freeSpaceInfo.outputFreeSpace) + ")");
        }
        if (freeSpaceInfo.cacheFreeSpace < 10000000000L || freeSpaceInfo.outputFreeSpace < 10000000000L) {
            this.freeSpaceLabel.setForeground(Color.RED);
        } else {
            this.freeSpaceLabel.setForeground(Color.BLACK);
        }
    }

    private ArrayList<StudyListItem> getItems(ErrorReporter errorReporter) {
        StudyListItem studyListItem;
        HashMap<Integer, StudyListItem> hashMap = new HashMap<Integer, StudyListItem>();
        HashMap<Integer, StudyListItem> hashMap2 = new HashMap<Integer, StudyListItem>();
        StudyListItem studyListItem2 = new StudyListItem();
        studyListItem2.isFolder = true;
        studyListItem2.folderKey = 0;
        if (null == this.dbName) {
            studyListItem2.name = "top";
        } else {
            studyListItem2.name = this.dbName;
        }
        studyListItem2.parentFolderKey = studyListItem2.folderKey;
        studyListItem2.items = new ArrayList();
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)errorReporter);
        if (null != dbConnection) {
            try {
                Integer n;
                if (this.showFolders) {
                    dbConnection.query("SELECT folder_key, name, parent_folder_key FROM folder ORDER BY 1");
                    while (dbConnection.next()) {
                        n = dbConnection.getInt(1);
                        if (n <= 0) continue;
                        studyListItem = new StudyListItem();
                        studyListItem.isFolder = true;
                        studyListItem.folderKey = n;
                        studyListItem.name = dbConnection.getString(2);
                        studyListItem.parentFolderKey = dbConnection.getInt(3);
                        studyListItem.items = new ArrayList();
                        hashMap2.put(n, studyListItem);
                    }
                    for (StudyListItem studyListItem3 : hashMap2.values()) {
                        studyListItem = (StudyListItem)hashMap2.get(studyListItem3.parentFolderKey);
                        if (null == studyListItem) {
                            studyListItem = studyListItem2;
                            studyListItem3.parentFolderKey = studyListItem.folderKey;
                        }
                        studyListItem.items.add(studyListItem3);
                    }
                }
                hashMap2.put(studyListItem2.folderKey, studyListItem2);
                dbConnection.query("SELECT study.study_key, study.name, study.description, study.study_lock, study.lock_count, study.study_type, template.name, study.ext_db_key, study.folder_key, study.has_result_tables, study.out_directory, study.created, study.modified, study.last_run FROM study JOIN template USING (template_key) ORDER BY 1");
                while (dbConnection.next()) {
                    n = dbConnection.getInt(1);
                    StudyListItem studyListItem4 = this.studyItemMap.get(n);
                    if (null == studyListItem4) {
                        studyListItem4 = new StudyListItem();
                        studyListItem4.key = n;
                        studyListItem4.cacheSize = -1L;
                    }
                    studyListItem4.name = dbConnection.getString(2);
                    studyListItem4.description = dbConnection.getString(3);
                    studyListItem4.studyLock = dbConnection.getInt(4);
                    studyListItem4.lockCount = dbConnection.getInt(5);
                    studyListItem4.studyType = dbConnection.getInt(6);
                    studyListItem4.templateName = dbConnection.getString(7);
                    studyListItem4.extDbName = "";
                    n = dbConnection.getInt(8);
                    if (n > 0) {
                        studyListItem4.extDbName = ExtDb.getExtDbDescription((String)this.dbID, (Integer)n);
                    }
                    studyListItem4.hasResultTables = dbConnection.getBoolean(10);
                    studyListItem4.outDirectory = dbConnection.getString(11);
                    studyListItem4.created = dbConnection.getString(12);
                    studyListItem4.modified = dbConnection.getString(13);
                    studyListItem4.lastRun = dbConnection.getString(14);
                    hashMap.put(studyListItem4.key, studyListItem4);
                    if (this.showFolders) {
                        studyListItem = (StudyListItem)hashMap2.get(dbConnection.getInt(9));
                        if (null == studyListItem) {
                            studyListItem = studyListItem2;
                        }
                    } else {
                        studyListItem = studyListItem2;
                    }
                    studyListItem.items.add(studyListItem4);
                }
                this.studyItemMap = hashMap;
                this.folderItemMap = hashMap2;
                DbCore.releaseDb((DbConnection)dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb((DbConnection)dbConnection);
                DbConnection.reportError((ErrorLogger)errorReporter, (SQLException)sQLException);
            }
        }
        if (null == (studyListItem = this.showFolders ? this.folderItemMap.get(this.currentFolderKey) : null)) {
            this.currentFolderKey = studyListItem2.folderKey;
            studyListItem = studyListItem2;
        }
        this.moveToFolderMenu.removeAll();
        this.cmMoveToFolderMenu.removeAll();
        if (this.showFolders) {
            this.addFolderAndDescend(studyListItem2, "");
        }
        return studyListItem.items;
    }

    private void addFolderAndDescend(StudyListItem studyListItem, String string) {
        JMenuItem jMenuItem = new JMenuItem(string + studyListItem.name);
        final int n = studyListItem.folderKey;
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doMoveToFolder(n);
            }
        });
        this.moveToFolderMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(string + studyListItem.name);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyManager.this.doMoveToFolder(n);
            }
        });
        this.cmMoveToFolderMenu.add(jMenuItem2);
        for (StudyListItem studyListItem2 : studyListItem.items) {
            if (!studyListItem2.isFolder || studyListItem2.isLink) continue;
            this.addFolderAndDescend(studyListItem2, string + "  ");
        }
    }

    private StudyListItem checkItem(int n, ErrorReporter errorReporter) {
        StudyListItem studyListItem = this.studyListModel.get(n);
        if (studyListItem.isFolder) {
            return studyListItem;
        }
        boolean bl = false;
        boolean bl2 = false;
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)errorReporter);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT study.name, study.description, study.study_lock, study.lock_count, template.name, study.ext_db_key, study.has_result_tables, study.out_directory, study.modified, study.last_run FROM study JOIN template USING (template_key) WHERE study.study_key = " + studyListItem.key);
                if (dbConnection.next()) {
                    studyListItem.name = dbConnection.getString(1);
                    studyListItem.description = dbConnection.getString(2);
                    studyListItem.studyLock = dbConnection.getInt(3);
                    studyListItem.lockCount = dbConnection.getInt(4);
                    studyListItem.templateName = dbConnection.getString(5);
                    studyListItem.extDbName = "";
                    int n2 = dbConnection.getInt(6);
                    if (n2 > 0) {
                        studyListItem.extDbName = ExtDb.getExtDbDescription((String)this.dbID, (Integer)n2);
                    }
                    studyListItem.hasResultTables = dbConnection.getBoolean(7);
                    studyListItem.outDirectory = dbConnection.getString(8);
                    studyListItem.modified = dbConnection.getString(9);
                    studyListItem.lastRun = dbConnection.getString(10);
                } else {
                    bl2 = true;
                }
                DbCore.releaseDb((DbConnection)dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb((DbConnection)dbConnection);
                bl = true;
                DbConnection.reportError((ErrorLogger)errorReporter, (SQLException)sQLException);
            }
        } else {
            return null;
        }
        if (bl2) {
            if (null != errorReporter) {
                errorReporter.reportError("The study does not exist");
            }
            this.updateStudyList(false, false, false);
            return null;
        }
        if (bl) {
            return null;
        }
        this.studyListModel.itemWasChanged(n);
        if (studyListItem.isCacheSizeExpired()) {
            this.addUpdateItem(studyListItem);
        }
        return studyListItem;
    }

    private void doPrevious() {
        int n = this.studyListTable.getRowCount();
        int n2 = this.studyListTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.studyListTable.setRowSelectionInterval(n2, n2);
            this.studyListTable.scrollRectToVisible(this.studyListTable.getCellRect(n2, 0, true));
        }
    }

    private void doNext() {
        int n = this.studyListTable.getRowCount();
        int n2 = this.studyListTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.studyListTable.setRowSelectionInterval(n2, n2);
            this.studyListTable.scrollRectToVisible(this.studyListTable.getCellRect(n2, 0, true));
        }
    }

    private void doBack() {
        StudyListItem studyListItem = this.studyListModel.get(0);
        if (studyListItem.isFolder && studyListItem.isLink) {
            this.showFolder(studyListItem);
        }
    }

    private void showFolder(StudyListItem studyListItem) {
        if (!this.showFolders || !studyListItem.isFolder) {
            return;
        }
        if (studyListItem.isLink && null == (studyListItem = this.folderItemMap.get(studyListItem.folderKey))) {
            studyListItem = this.folderItemMap.get(0);
        }
        this.currentFolderKey = studyListItem.folderKey;
        this.studyListModel.setItems(studyListItem.items, true);
        this.updateControls();
        this.updateDocumentName();
    }

    private void doCreateFolder() {
        String string = "Create Folder";
        this.errorReporter.setTitle(string);
        while (true) {
            DbConnection dbConnection;
            String string2;
            if (null == (string2 = (String)JOptionPane.showInputDialog(this, "Enter a name for the new folder", string, 3, null, null, ""))) {
                return;
            }
            if (0 == (string2 = string2.trim()).length()) continue;
            if (string2.length() > 245) {
                string2 = string2.substring(0, 245);
            }
            if (null == (dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)this.errorReporter))) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            String string3 = "";
            try {
                dbConnection.update("LOCK TABLES folder WRITE");
                dbConnection.query("SELECT folder_key FROM folder WHERE UPPER(name) = '" + DbConnection.clean((String)string2.toUpperCase()) + "'");
                if (dbConnection.next()) {
                    bl = true;
                } else {
                    if (this.currentFolderKey > 0) {
                        dbConnection.query("SELECT folder_key FROM folder WHERE folder_key = " + this.currentFolderKey);
                        if (!dbConnection.next()) {
                            bl2 = true;
                            string3 = "The enclosing folder does not exist";
                        }
                    }
                    if (!bl2) {
                        dbConnection.query("SELECT MAX(folder_key) FROM folder");
                        dbConnection.next();
                        Integer n = dbConnection.getInt(1) + 1;
                        dbConnection.update("INSERT INTO folder VALUES (" + n + ",'" + DbConnection.clean((String)string2) + "'," + this.currentFolderKey + ")");
                    }
                }
            }
            catch (SQLException sQLException) {
                bl2 = true;
                string3 = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError((SQLException)sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError((SQLException)sQLException);
            }
            DbCore.releaseDb((DbConnection)dbConnection);
            if (bl2) {
                this.errorReporter.reportError("Cannot create folder:\n" + string3);
                return;
            }
            if (!bl) break;
            this.errorReporter.reportWarning("That folder name is already in use, please try again");
        }
        this.updateStudyList(false, true, true);
    }

    private void doRenameFolder() {
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        String string = "Rename Folder";
        this.errorReporter.setTitle(string);
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkItem(n, this.errorReporter);
        if (null == studyListItem || !studyListItem.isFolder || studyListItem.isLink) {
            return;
        }
        while (true) {
            String string2;
            if (null == (string2 = (String)JOptionPane.showInputDialog(this, "Enter a new name for the folder", string, 3, null, null, studyListItem.name))) {
                return;
            }
            if (0 == (string2 = string2.trim()).length()) continue;
            if (string2.equals(studyListItem.name)) {
                return;
            }
            DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)this.errorReporter);
            if (null == dbConnection) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            String string3 = "";
            try {
                dbConnection.update("LOCK TABLES folder WRITE");
                dbConnection.query("SELECT folder_key FROM folder WHERE UPPER(name) = '" + DbConnection.clean((String)string2.toUpperCase()) + "'");
                if (dbConnection.next() && dbConnection.getInt(1) != studyListItem.folderKey.intValue()) {
                    bl = true;
                } else {
                    dbConnection.update("UPDATE folder SET name = '" + DbConnection.clean((String)string2) + "' WHERE folder_key = " + studyListItem.folderKey);
                }
                studyListItem.name = string2;
            }
            catch (SQLException sQLException) {
                bl2 = true;
                string3 = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError((SQLException)sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError((SQLException)sQLException);
            }
            DbCore.releaseDb((DbConnection)dbConnection);
            if (bl2) {
                this.errorReporter.reportError("Cannot rename folder:\n" + string3);
                return;
            }
            if (!bl) break;
            this.errorReporter.reportWarning("That folder name is already in use, please try again");
        }
        this.studyListModel.itemWasChanged(n);
    }

    private void doMoveToFolder(int n) {
        int n2 = this.studyListTable.getSelectedRowCount();
        if (0 == n2) {
            return;
        }
        if (this.currentFolderKey == n) {
            return;
        }
        String string = "Move To Folder";
        this.errorReporter.setTitle(string);
        StudyListItem studyListItem = this.folderItemMap.get(n);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        StudyListItem studyListItem2 = this.folderItemMap.get(studyListItem.parentFolderKey);
        while (studyListItem2.folderKey > 0) {
            hashSet.add(studyListItem2.folderKey);
            studyListItem2 = this.folderItemMap.get(studyListItem2.parentFolderKey);
        }
        boolean bl = false;
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        int[] nArray = this.studyListTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            StudyListItem studyListItem3 = this.studyListModel.get(this.studyListTable.convertRowIndexToModel(nArray[i]));
            if (studyListItem3.isFolder) {
                if (studyListItem3.isLink || studyListItem3.folderKey == n) continue;
                if (hashSet.contains(studyListItem3.folderKey)) {
                    bl = true;
                    continue;
                }
                hashSet3.add(studyListItem3.folderKey);
                continue;
            }
            hashSet2.add(studyListItem3.key);
        }
        if (hashSet3.isEmpty() && hashSet2.isEmpty()) {
            if (bl) {
                this.errorReporter.reportWarning("A folder can't be moved to it's own sub-folder");
            }
            return;
        }
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)this.errorReporter);
        if (null == dbConnection) {
            return;
        }
        boolean bl2 = false;
        String string2 = "";
        try {
            dbConnection.update("LOCK TABLES study WRITE, folder WRITE");
            if (n > 0) {
                dbConnection.query("SELECT folder_key FROM folder WHERE folder_key = " + n);
                if (!dbConnection.next()) {
                    bl2 = true;
                    string2 = "The destination folder does not exist";
                }
            }
            if (!bl2) {
                if (!hashSet2.isEmpty()) {
                    dbConnection.update("UPDATE study SET folder_key = " + n + " WHERE study_key IN " + DbConnection.makeKeyList(hashSet2));
                }
                if (!hashSet3.isEmpty()) {
                    dbConnection.update("UPDATE folder SET parent_folder_key = " + n + " WHERE folder_key IN " + DbConnection.makeKeyList(hashSet3));
                }
            }
        }
        catch (SQLException sQLException) {
            bl2 = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError((SQLException)sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError((SQLException)sQLException);
        }
        DbCore.releaseDb((DbConnection)dbConnection);
        this.updateStudyList(false, false, false);
        if (bl2) {
            this.errorReporter.reportError("Cannot move items to folder:\n" + string2);
            return;
        }
    }

    private void doCreateNewStudy(int n) {
        String string = "Create " + Study.getStudyTypeName((int)n) + " Study";
        this.errorReporter.setTitle(string);
        if (2 == n) {
            if (null != this.studyBuildWizard && this.studyBuildWizard.isVisible()) {
                AppController.beep();
                this.studyBuildWizard.toFront();
                return;
            }
            StudyBuildIxCheck studyBuildIxCheck = new StudyBuildIxCheck(this.dbID);
            studyBuildIxCheck.buildFullStudy = false;
            studyBuildIxCheck.loadDefaults();
            studyBuildIxCheck.studyFolderKey = this.currentFolderKey;
            this.studyBuildWizard = new RecordFind(this, string, 0, 1);
            if (null != studyBuildIxCheck.extDb) {
                this.studyBuildWizard.setDefaultExtDbKey(studyBuildIxCheck.extDb.key);
            }
            this.studyBuildWizard.setNote("Select proposal TV station record");
            this.studyBuildWizard.setAccessoryPanel(new OptionsPanel.IxCheckStudy((AppEditor)this, studyBuildIxCheck));
            this.studyBuildWizard.setApply(new String[]{"Create"}, new int[]{1}, true, true);
            AppController.showWindow(this.studyBuildWizard);
            return;
        }
        final StudyCreateNew studyCreateNew = new StudyCreateNew(string, Study.getDefaultRecordType((int)n));
        AppController.showWindow(studyCreateNew);
        if (studyCreateNew.canceled) {
            return;
        }
        final int n2 = n;
        BackgroundWorker<Integer> backgroundWorker = new BackgroundWorker<Integer>((Window)this, string){

            @Override
            protected Integer doBackgroundWork(ErrorLogger errorLogger) {
                return Study.createNewStudy((String)StudyManager.this.dbID, (String)studyCreateNew.studyName, (int)n2, (int)studyCreateNew.templateKey, (Integer)studyCreateNew.extDbKey, (Integer)StudyManager.this.currentFolderKey, (ErrorLogger)errorLogger);
            }
        };
        this.errorReporter.clearMessages();
        Integer n3 = (Integer)backgroundWorker.runWork("Creating new study, please wait...", this.errorReporter);
        if (null == n3) {
            return;
        }
        this.errorReporter.showMessages();
        this.updateStudyList(false, false, true);
        int n4 = this.studyListModel.indexOfStudy(n3);
        if (n4 < 0) {
            return;
        }
        n4 = this.studyListTable.convertRowIndexToView(n4);
        this.studyListTable.setRowSelectionInterval(n4, n4);
        this.studyListTable.scrollRectToVisible(this.studyListTable.getCellRect(n4, 0, true));
        this.doOpenItem(null);
    }

    private void doRunNewStudy(int n) {
        int[] nArray;
        String[] stringArray;
        if (null != this.studyBuildWizard && this.studyBuildWizard.isVisible()) {
            AppController.beep();
            this.studyBuildWizard.toFront();
            return;
        }
        String string = "Build " + Study.getStudyTypeName((int)n) + " Study";
        this.errorReporter.setTitle(string);
        if (AppCore.maxEngineProcessCount > 0) {
            stringArray = new String[]{"Build", "Build & Run"};
            nArray = new int[]{1, 2};
        } else {
            stringArray = new String[]{"Build"};
            nArray = new int[]{1};
        }
        switch (n) {
            default: {
                return;
            }
            case 2: {
                StudyBuildIxCheck studyBuildIxCheck = new StudyBuildIxCheck(this.dbID);
                studyBuildIxCheck.loadDefaults();
                studyBuildIxCheck.studyFolderKey = this.currentFolderKey;
                this.studyBuildWizard = new RecordFind(this, string, 0, 1);
                if (null != studyBuildIxCheck.extDb) {
                    this.studyBuildWizard.setDefaultExtDbKey(studyBuildIxCheck.extDb.key);
                }
                this.studyBuildWizard.setNote("Select proposal TV station record");
                this.studyBuildWizard.setAccessoryPanel(new OptionsPanel.IxCheckStudy((AppEditor)this, studyBuildIxCheck));
                this.studyBuildWizard.setApply(stringArray, nArray, false, true);
                break;
            }
            case 3: {
                StudyBuildWireless studyBuildWireless = new StudyBuildWireless(this.dbID);
                studyBuildWireless.studyFolderKey = this.currentFolderKey;
                this.studyBuildWizard = new RecordFind(this, string, 0, 1);
                this.studyBuildWizard.setNote("Select protected TV station record(s)");
                this.studyBuildWizard.setAccessoryPanel(new OptionsPanel.WirelessStudy((AppEditor)this, studyBuildWireless));
                this.studyBuildWizard.setApply(stringArray, nArray, true, true);
                break;
            }
            case 5: {
                StudyBuildTV6FM studyBuildTV6FM = new StudyBuildTV6FM(this.dbID);
                studyBuildTV6FM.studyFolderKey = this.currentFolderKey;
                this.studyBuildWizard = new RecordFind(this, string, 0, 1);
                this.studyBuildWizard.setNote("Select TV channel 6 station record");
                this.studyBuildWizard.setAccessoryPanel(new OptionsPanel.TV6FMStudy((AppEditor)this, studyBuildTV6FM));
                this.studyBuildWizard.setApply(stringArray, nArray, true, true);
                break;
            }
        }
        AppController.showWindow(this.studyBuildWizard);
    }

    private void doDuplicateStudy() {
        String string;
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        String string2 = "Duplicate Study";
        this.errorReporter.setTitle(string2);
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkItem(n, this.errorReporter);
        if (null == studyListItem || studyListItem.isFolder) {
            return;
        }
        StudyLockHolder studyLockHolder = this.lockHolders.get(studyListItem.key);
        if (null != studyLockHolder) {
            if (studyLockHolder.isVisible()) {
                AppController.beep();
                studyLockHolder.toFront();
                return;
            }
            this.lockHolders.remove(studyListItem.key);
        }
        if (0 != studyListItem.studyLock) {
            this.errorReporter.reportWarning("Could not duplicate study '" + studyListItem.name + "':\nThe study is in use by another application");
            return;
        }
        boolean bl = false;
        if (!this.editLockSet) {
            if (!this.acquireEditLock()) {
                return;
            }
            bl = true;
        }
        String string3 = "";
        do {
            if (null != (string3 = (String)JOptionPane.showInputDialog(this, "Enter a name for the new study", string2, 3, null, null, studyListItem.name))) continue;
            if (bl) {
                this.clearEditLock();
            }
            return;
        } while (!DbCore.checkStudyName((String)(string3 = string3.trim()), (String)this.dbID, (boolean)true, (ErrorLogger)this.errorReporter));
        final int n2 = studyListItem.key;
        BackgroundWorker<Integer> backgroundWorker = new BackgroundWorker<Integer>((Window)this, string2, string = string3){
            final /* synthetic */ String val$newName;
            {
                this.val$newName = string2;
                super(window, string);
            }

            @Override
            protected Integer doBackgroundWork(ErrorLogger errorLogger) {
                return Study.duplicateStudy((String)StudyManager.this.dbID, (int)n2, (String)this.val$newName, (ErrorLogger)errorLogger);
            }
        };
        Integer n3 = (Integer)backgroundWorker.runWork("Duplicating study, please wait...", this.errorReporter);
        if (null != n3) {
            this.updateStudyList(false, false, false);
            n = this.studyListModel.indexOfStudy(n3);
            if (n >= 0) {
                n = this.studyListTable.convertRowIndexToView(n);
                this.studyListTable.setRowSelectionInterval(n, n);
                this.studyListTable.scrollRectToVisible(this.studyListTable.getCellRect(n, 0, true));
            }
        }
        if (bl) {
            this.clearEditLock();
        }
    }

    private void doOpenItem(Study study) {
        StudyLockHolder studyLockHolder;
        String string = "Open";
        this.errorReporter.setTitle(string);
        int n = -1;
        StudyListItem studyListItem = null;
        if (null == study) {
            int n2;
            BackgroundWorker<Study> backgroundWorker;
            if (this.studyListTable.getSelectedRowCount() != 1) {
                return;
            }
            n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
            studyListItem = this.checkItem(n, this.errorReporter);
            if (null == studyListItem) {
                return;
            }
            if (studyListItem.isFolder) {
                this.showFolder(studyListItem);
                return;
            }
            studyLockHolder = this.lockHolders.get(studyListItem.key);
            if (null != studyLockHolder) {
                if (studyLockHolder.isVisible()) {
                    studyLockHolder.toFront();
                    return;
                }
                this.lockHolders.remove(studyListItem.key);
            }
            if (null == (study = (Study)(backgroundWorker = new BackgroundWorker<Study>((Window)this, string, n2 = studyListItem.key.intValue()){
                final /* synthetic */ int val$theKey;
                {
                    this.val$theKey = n;
                    super(window, string);
                }

                @Override
                protected Study doBackgroundWork(ErrorLogger errorLogger) {
                    return Study.getStudy((String)StudyManager.this.dbID, (int)this.val$theKey, (ErrorLogger)errorLogger);
                }
            }).runWork("Opening study, please wait...", this.errorReporter))) {
                return;
            }
        } else {
            this.updateStudyList(false, false, true);
            n = this.studyListModel.indexOfStudy(study.key);
            if (n < 0) {
                return;
            }
            int n3 = this.studyListTable.convertRowIndexToView(n);
            this.studyListTable.setRowSelectionInterval(n3, n3);
            this.studyListTable.scrollRectToVisible(this.studyListTable.getCellRect(n3, 0, true));
            studyListItem = this.studyListModel.get(n);
        }
        try {
            studyLockHolder = new StudyEditor((AppEditor)this, new StudyEditData(study));
        }
        catch (Throwable throwable) {
            Study.unlockStudy((String)this.dbID, (int)study.key, (int)study.lockCount);
            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
            this.errorReporter.reportError("Unexpected error:\n" + throwable);
            return;
        }
        studyListItem.studyLock = study.studyLock;
        studyListItem.lockCount = study.lockCount;
        AppController.showWindow((Window)((Object)studyLockHolder));
        this.lockHolders.put(studyListItem.key, studyLockHolder);
        this.studyListModel.itemWasChanged(n);
        this.updateControls();
    }

    private void doRunStudy(boolean bl) {
        if (AppCore.maxEngineProcessCount < 1) {
            return;
        }
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        this.errorReporter.setTitle("Run Study");
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkItem(n, this.errorReporter);
        if (null == studyListItem || studyListItem.isFolder) {
            return;
        }
        StudyLockHolder studyLockHolder = this.lockHolders.get(studyListItem.key);
        if (null != studyLockHolder) {
            if (studyLockHolder.isVisible()) {
                AppController.beep();
                studyLockHolder.toFront();
                return;
            }
            this.lockHolders.remove(studyListItem.key);
        }
        RunStart runStart = null;
        runStart = bl ? new RunStartPairStudy(this) : new RunStartStudy(this);
        if (!runStart.setStudy(studyListItem.key, this.errorReporter)) {
            return;
        }
        AppController.showWindow(runStart);
        studyListItem.studyLock = runStart.getStudyLock();
        studyListItem.lockCount = runStart.getLockCount();
        this.lockHolders.put(studyListItem.key, runStart);
        this.studyListModel.itemWasChanged(n);
        this.updateControls();
    }

    private void doAnalyzeStudy() {
        int n;
        BackgroundWorker<Study> backgroundWorker;
        Study study;
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        String string = "Analyze Run Result";
        this.errorReporter.setTitle(string);
        int n2 = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkItem(n2, this.errorReporter);
        if (null == studyListItem || studyListItem.isFolder) {
            return;
        }
        StudyLockHolder studyLockHolder = this.lockHolders.get(studyListItem.key);
        if (null != studyLockHolder) {
            if (studyLockHolder.isVisible()) {
                AppController.beep();
                studyLockHolder.toFront();
                return;
            }
            this.lockHolders.remove(studyListItem.key);
        }
        if (null == (study = (Study)(backgroundWorker = new BackgroundWorker<Study>((Window)this, string, n = studyListItem.key.intValue()){
            final /* synthetic */ int val$theKey;
            {
                this.val$theKey = n;
                super(window, string);
            }

            @Override
            protected Study doBackgroundWork(ErrorLogger errorLogger) {
                return Study.getStudy((String)StudyManager.this.dbID, (int)this.val$theKey, (ErrorLogger)errorLogger);
            }
        }).runWork("Opening study, please wait...", this.errorReporter))) {
            return;
        }
        AnalyzeRunResult analyzeRunResult = new AnalyzeRunResult(this);
        if (!analyzeRunResult.setStudy(study, this.errorReporter)) {
            Study.unlockStudy((String)this.dbID, (int)study.key, (int)study.lockCount);
            return;
        }
        studyListItem.studyLock = study.studyLock;
        studyListItem.lockCount = study.lockCount;
        AppController.showWindow(analyzeRunResult);
        this.lockHolders.put(studyListItem.key, analyzeRunResult);
        this.studyListModel.itemWasChanged(n2);
        this.updateControls();
    }

    private void doDeleteItem() {
        String string = "Delete";
        this.errorReporter.setTitle(string);
        int n = this.studyListTable.getSelectedRowCount();
        if (0 == n) {
            return;
        }
        final ArrayList<StudyListItem> arrayList = new ArrayList<StudyListItem>();
        final ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        int[] nArray = this.studyListTable.getSelectedRows();
        boolean bl = true;
        boolean bl2 = false;
        Object[] objectArray = new String[]{"Yes", "No", "Cancel"};
        String[] stringArray = new String[]{"Yes", "No", "Cancel", "Yes to all"};
        JCheckBox jCheckBox = new JCheckBox("Also delete study output files");
        Object[] objectArray2 = new Object[2];
        objectArray2[1] = jCheckBox;
        block5: for (int i = 0; i < nArray.length; ++i) {
            StudyLockHolder studyLockHolder;
            StudyListItem studyListItem = this.studyListModel.get(this.studyListTable.convertRowIndexToModel(nArray[i]));
            if (studyListItem.isFolder) {
                if (studyListItem.isLink) continue;
                if (0 == studyListItem.items.size()) {
                    arrayList.add(studyListItem);
                    arrayList2.add(Boolean.FALSE);
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (bl) {
                Object[] objectArray3;
                AppController.beep();
                int n2 = nArray.length - i - 1;
                if (n2 > 0) {
                    objectArray2[0] = "Are you sure you want to delete study '" + studyListItem.name + "' and " + n2 + " other " + (n2 > 1 ? "items?" : "item?");
                    objectArray3 = stringArray;
                } else {
                    objectArray2[0] = "Are you sure you want to delete study '" + studyListItem.name + "'?";
                    objectArray3 = objectArray;
                }
                switch (JOptionPane.showOptionDialog(this, objectArray2, string, -1, 2, null, objectArray3, objectArray3[0])) {
                    case 0: {
                        break;
                    }
                    default: {
                        continue block5;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        bl = false;
                    }
                }
            }
            if (null != (studyLockHolder = this.lockHolders.get(studyListItem.key))) {
                if (studyLockHolder.isVisible()) {
                    this.holdStudyLocks = true;
                    boolean bl3 = !studyLockHolder.closeWithoutSave();
                    this.holdStudyLocks = false;
                    if (bl3) {
                        this.errorReporter.reportWarning("Could not close a window for study '" + studyListItem.name + "'\nPlease close the window manually and try again");
                        continue;
                    }
                }
                this.lockHolders.remove(studyListItem.key);
            }
            arrayList.add(studyListItem);
            arrayList2.add(jCheckBox.isSelected());
        }
        if (bl2) {
            this.errorReporter.reportWarning("Some folders could not be deleted because they are not empty");
        }
        if (arrayList.isEmpty()) {
            return;
        }
        BackgroundWorker<Object> backgroundWorker = new BackgroundWorker<Object>((Window)this, string){

            @Override
            protected Object doBackgroundWork(ErrorLogger errorLogger) {
                StudyManager.this.deleteItems(errorLogger, arrayList, arrayList2);
                return null;
            }
        };
        backgroundWorker.runWork("Deleting studies, please wait...", this.errorReporter);
        this.updateStudyList(false, false, false);
    }

    private void deleteItems(ErrorLogger errorLogger, ArrayList<StudyListItem> arrayList, ArrayList<Boolean> arrayList2) {
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        int n = 0;
        int n2 = 0;
        String string2 = DbCore.getDbName((String)this.dbID);
        String string3 = DbCore.getHostDbName((String)this.dbID);
        for (int i = 0; i < arrayList.size(); ++i) {
            StudyListItem studyListItem = arrayList.get(i);
            DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)errorLogger);
            if (null == dbConnection) {
                return;
            }
            bl = false;
            string = "";
            bl2 = false;
            try {
                if (studyListItem.isFolder) {
                    dbConnection.update("LOCK TABLES study WRITE, folder WRITE");
                    dbConnection.query("SELECT COUNT(*) FROM study WHERE folder_key = " + studyListItem.folderKey);
                    if (dbConnection.next() && dbConnection.getInt(1) > 0) {
                        bl = true;
                        string = "The folder is not empty";
                    } else {
                        dbConnection.query("SELECT COUNT(*) FROM folder WHERE parent_folder_key = " + studyListItem.folderKey);
                        if (dbConnection.next() && dbConnection.getInt(1) > 0) {
                            bl = true;
                            string = "The folder is not empty";
                        } else {
                            dbConnection.update("DELETE FROM folder WHERE folder_key = " + studyListItem.folderKey);
                        }
                    }
                } else {
                    dbConnection.update("LOCK TABLES study WRITE");
                    dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + studyListItem.key);
                    if (dbConnection.next()) {
                        n = dbConnection.getInt(1);
                        n2 = dbConnection.getInt(2);
                        if (0 == n) {
                            dbConnection.update("UPDATE study SET study_lock = 4, lock_count = lock_count + 1 WHERE study_key = " + studyListItem.key);
                            ++n2;
                        } else if (!this.lockHolders.containsKey(studyListItem.key) || 1 != n || n != studyListItem.studyLock || n2 != studyListItem.lockCount) {
                            bl = true;
                            string = "The study is in use by another application";
                        }
                    } else {
                        bl2 = true;
                    }
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError((SQLException)sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError((SQLException)sQLException);
            }
            DbCore.releaseDb((DbConnection)dbConnection);
            if (bl) {
                errorLogger.reportError("Cannot delete '" + studyListItem.name + "':\n" + string);
                continue;
            }
            if (studyListItem.isFolder || bl2 || !Study.deleteStudy((String)this.dbID, (int)studyListItem.key, (int)n2, (ErrorLogger)errorLogger)) continue;
            DbCore.deleteProperty((String)this.dbID, (String)("Study " + studyListItem.key + "%"));
            if (!arrayList2.get(i).booleanValue()) continue;
            Path path = Paths.get(studyListItem.outDirectory, new String[0]);
            if (!path.isAbsolute()) {
                path = AppCore.workingDirectoryPath.resolve(path);
            }
            if (null != string3) {
                path = path.resolve(string3);
            }
            AppCore.deleteDirectoryAndContents((File)path.resolve(studyListItem.name).toFile());
        }
    }

    private void doClearCache() {
        String string = "Clear Cache";
        this.errorReporter.setTitle(string);
        int n = this.studyListTable.getSelectedRowCount();
        if (0 == n) {
            return;
        }
        final ArrayList<StudyListItem> arrayList = new ArrayList<StudyListItem>();
        int[] nArray = this.studyListTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            StudyListItem studyListItem = this.studyListModel.get(this.studyListTable.convertRowIndexToModel(nArray[i]));
            if (studyListItem.isFolder) continue;
            arrayList.add(studyListItem);
        }
        BackgroundWorker<Object> backgroundWorker = new BackgroundWorker<Object>((Window)this, string){

            @Override
            protected Object doBackgroundWork(ErrorLogger errorLogger) {
                StudyManager.this.clearCaches(errorLogger, arrayList);
                return null;
            }
        };
        backgroundWorker.runWork("Deleting cache files, please wait...", this.errorReporter);
        this.updateStudyList(false, true, false);
    }

    private void clearCaches(ErrorLogger errorLogger, ArrayList<StudyListItem> arrayList) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        for (StudyListItem studyListItem : arrayList) {
            DbConnection dbConnection = DbCore.connectDb((String)this.dbID, (ErrorLogger)errorLogger);
            if (null == dbConnection) {
                return;
            }
            bl = false;
            string = "";
            bl2 = false;
            bl3 = false;
            try {
                dbConnection.update("LOCK TABLES study WRITE");
                dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + studyListItem.key);
                if (dbConnection.next()) {
                    int n = dbConnection.getInt(1);
                    if (0 == n) {
                        studyListItem.lockCount = dbConnection.getInt(2);
                        dbConnection.update("UPDATE study SET study_lock = 4, lock_count = lock_count + 1 WHERE study_key = " + studyListItem.key);
                        bl3 = true;
                        studyListItem.studyLock = 4;
                        studyListItem.lockCount++;
                        final StudyListItem studyListItem2 = studyListItem;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StudyManager.this.studyListModel.itemWasChanged(studyListItem2);
                            }
                        });
                    } else if (!this.lockHolders.containsKey(studyListItem.key) || 1 != n || n != studyListItem.studyLock || dbConnection.getInt(2) != studyListItem.lockCount) {
                        bl = true;
                        string = "The study is in use by another application";
                    }
                } else {
                    bl2 = true;
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError((SQLException)sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError((SQLException)sQLException);
            }
            if (bl) {
                DbCore.releaseDb((DbConnection)dbConnection);
                errorLogger.reportError("Cache cannot be cleared for study '" + studyListItem.name + "':\n" + string);
                continue;
            }
            if (bl2) {
                DbCore.releaseDb((DbConnection)dbConnection);
                continue;
            }
            AppCore.deleteStudyCache((String)this.dbID, (int)studyListItem.key);
            studyListItem.clearCacheSize();
            if (bl3) {
                try {
                    dbConnection.update("UPDATE study SET study_lock = 0, lock_count = lock_count + 1 WHERE study_key = " + studyListItem.key);
                    studyListItem.studyLock = 0;
                    studyListItem.lockCount++;
                    final StudyListItem studyListItem3 = studyListItem;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StudyManager.this.studyListModel.itemWasChanged(studyListItem3);
                        }
                    });
                }
                catch (SQLException sQLException) {
                    DbConnection.reportError((SQLException)sQLException);
                }
            }
            DbCore.releaseDb((DbConnection)dbConnection);
        }
    }

    private void doUnlockStudy() {
        String string = "Unlock Study";
        this.errorReporter.setTitle(string);
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkItem(n, this.errorReporter);
        if (null == studyListItem || studyListItem.isFolder) {
            return;
        }
        StudyLockHolder studyLockHolder = this.lockHolders.get(studyListItem.key);
        if (null != studyLockHolder) {
            if (studyLockHolder.isVisible()) {
                AppController.beep();
                studyLockHolder.toFront();
                return;
            }
            this.lockHolders.remove(studyListItem.key);
        }
        AppController.beep();
        if (0 != JOptionPane.showConfirmDialog(this, "This will clear the lock on the study.  Do this only if the study was\nnot closed properly due to an application crash or network failure;\nif this is done when another application is still using the study,\nthat application will fail and the data could become corrupted.\n\nDo you want to continue?", string, 0, 2)) {
            return;
        }
        Study.unlockStudy((String)this.dbID, (int)studyListItem.key, (int)0, (ErrorLogger)this.errorReporter);
        this.checkItem(n, null);
    }

    private void doStudyInfo() {
        String string = "Study Info";
        this.errorReporter.setTitle(string);
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkItem(n, this.errorReporter);
        if (null == studyListItem || studyListItem.isFolder) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Name: ");
        stringBuilder.append(studyListItem.name);
        stringBuilder.append('\n');
        stringBuilder.append("Type: ");
        stringBuilder.append(Study.getStudyTypeName((int)studyListItem.studyType));
        stringBuilder.append('\n');
        stringBuilder.append("Created: ");
        stringBuilder.append(null == studyListItem.created ? "(unknown)" : studyListItem.created);
        stringBuilder.append('\n');
        stringBuilder.append("Modified: ");
        stringBuilder.append(null == studyListItem.modified ? (null == studyListItem.created ? "(unknown)" : "(never)") : studyListItem.modified);
        stringBuilder.append('\n');
        stringBuilder.append("Last run: ");
        stringBuilder.append(null == studyListItem.lastRun ? (null == studyListItem.created ? "(unknown)" : "(never)") : studyListItem.lastRun);
        stringBuilder.append('\n');
        stringBuilder.append("Primary key: ");
        stringBuilder.append(String.valueOf(studyListItem.key));
        stringBuilder.append('\n');
        stringBuilder.append("Database name: ");
        stringBuilder.append(Study.makeDbName((String)DbCore.getDbName((String)this.dbID), (int)studyListItem.key));
        stringBuilder.append('\n');
        stringBuilder.append("Output directory: ");
        stringBuilder.append(studyListItem.outDirectory);
        if (studyListItem.hasResultTables) {
            stringBuilder.append("\nHas study result tables");
        }
        if (0 != studyListItem.studyLock) {
            stringBuilder.append("Locked");
            switch (studyListItem.studyLock) {
                case 1: {
                    stringBuilder.append(" for editing");
                    break;
                }
                case 2: 
                case 3: {
                    stringBuilder.append(" for study run");
                    break;
                }
                case 4: {
                    stringBuilder.append(" for administrative action");
                }
            }
            if (null == this.lockHolders.get(studyListItem.key)) {
                stringBuilder.append(" by another application");
            }
        }
        AppController.showMessage(this, (Object)stringBuilder.toString(), "Study Info");
    }

    private void doShowStationDataViewer() {
        if (null != this.stationDataViewer && this.stationDataViewer.isVisible()) {
            this.stationDataViewer.toFront();
            return;
        }
        this.stationDataViewer = new RecordFind(this, "View Station Data", 0, 0);
        AppController.showWindow(this.stationDataViewer);
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        if (!this.isVisible()) {
            return true;
        }
        if (appEditor instanceof RunStart) {
            RunStart runStart = (RunStart)appEditor;
            Integer n = runStart.getStudyKey();
            if (runStart != this.lockHolders.get(n)) {
                return false;
            }
            RunPanel runPanel = runStart.getRunPanel();
            StudyLockHolder studyLockHolder = runStart.getStudyLockHolder();
            if (null == runPanel || null == studyLockHolder) {
                return false;
            }
            RunManager.addRunPanel(runPanel);
            this.lockHolders.put(n, studyLockHolder);
            return true;
        }
        if (appEditor instanceof StudyLockHolder) {
            int n;
            StudyLockHolder studyLockHolder = (StudyLockHolder)((Object)appEditor);
            Integer n2 = studyLockHolder.getStudyKey();
            if (!this.lockHolders.containsKey(n2)) {
                this.lockHolders.put(n2, studyLockHolder);
                this.updateStudyList(false, true, false);
            }
            if ((n = this.studyListModel.indexOfStudy(n2)) >= 0) {
                this.studyListModel.get(n).clearCacheSize();
                this.checkItem(n, null);
            }
            return true;
        }
        if (appEditor instanceof RecordFind) {
            StudyBuildIxCheck studyBuildIxCheck;
            RecordFind recordFind = (RecordFind)appEditor;
            if (recordFind != this.studyBuildWizard) {
                return false;
            }
            ErrorReporter errorReporter = recordFind.getErrorReporter();
            OptionsPanel optionsPanel = (OptionsPanel)recordFind.getAccessoryPanel();
            if (optionsPanel instanceof OptionsPanel.IxCheckStudy) {
                studyBuildIxCheck = ((OptionsPanel.IxCheckStudy)optionsPanel).getStudyBuild();
                if (!studyBuildIxCheck.buildFullStudy) {
                    BackgroundWorker<Study> backgroundWorker = new BackgroundWorker<Study>((Window)recordFind, recordFind.getTitle()){

                        @Override
                        protected Study doBackgroundWork(ErrorLogger errorLogger) {
                            if (!studyBuildIxCheck.initialize(errorLogger)) {
                                return null;
                            }
                            return studyBuildIxCheck.buildStudy(errorLogger);
                        }
                    };
                    final Study study = (Study)backgroundWorker.runWork("Creating study, please wait...", errorReporter);
                    if (null == study) {
                        return false;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StudyManager.this.doOpenItem(study);
                        }
                    });
                    return true;
                }
            }
            if (null == (studyBuildIxCheck = optionsPanel.getStudyBuilds())) {
                errorReporter.reportError("Invalid study configuration");
                return false;
            }
            ArrayList<RunPanelStudy> arrayList = new ArrayList<RunPanelStudy>();
            for (StudyBuild object : studyBuildIxCheck) {
                RunPanelStudy runPanelStudy = new RunPanelStudy(this, this.dbID);
                runPanelStudy.studyBuild = object;
                runPanelStudy.runAfterBuild = 2 == recordFind.applyButtonID;
                runPanelStudy.fileOutputConfig = optionsPanel.fileOutputConfig;
                runPanelStudy.mapOutputConfig = optionsPanel.mapOutputConfig;
                runPanelStudy.memoryFraction = optionsPanel.memoryFraction;
                runPanelStudy.runComment = optionsPanel.comment;
                if (!runPanelStudy.initialize(errorReporter)) {
                    return false;
                }
                arrayList.add(runPanelStudy);
            }
            for (RunPanelStudy runPanelStudy : arrayList) {
                RunManager.addRunPanel(runPanelStudy);
            }
            return true;
        }
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
        if (!this.isVisible()) {
            return;
        }
        if (appEditor instanceof StudyLockHolder) {
            StudyLockHolder studyLockHolder = (StudyLockHolder)((Object)appEditor);
            int n = studyLockHolder.getStudyKey();
            Integer n2 = n;
            if (this.lockHolders.remove(n2, studyLockHolder)) {
                int n3;
                StudyListItem studyListItem;
                if (0 != studyLockHolder.getStudyLock() && !this.holdStudyLocks) {
                    Study.unlockStudy((String)this.dbID, (int)n, (int)studyLockHolder.getLockCount());
                }
                if (null != (studyListItem = this.studyItemMap.get(n2)) && (n3 = this.studyListModel.indexOf(studyListItem)) >= 0) {
                    this.checkItem(n3, null);
                    this.updateControls();
                }
            }
            return;
        }
        if (appEditor instanceof RecordFind) {
            RecordFind recordFind = (RecordFind)appEditor;
            if (recordFind == this.stationDataViewer) {
                this.stationDataViewer = null;
                return;
            }
            if (recordFind == this.studyBuildWizard) {
                this.studyBuildWizard = null;
                return;
            }
        }
        if (appEditor == this.geographyEditor) {
            if (null == this.receiveAntennaEditor || !this.receiveAntennaEditor.isVisible()) {
                this.clearEditLock();
            }
            return;
        }
        if (appEditor == this.receiveAntennaEditor) {
            if (null == this.geographyEditor || !this.geographyEditor.isVisible()) {
                this.clearEditLock();
            }
            return;
        }
    }

    @Override
    public void windowWillOpen() {
        if (this.isVisible()) {
            return;
        }
        DbCore.openDb((String)this.dbID, (Object)this);
        DbController.restoreColumnWidths(this.dbID, this.getKeyTitle(), this.studyListTable);
        this.blockActionsClear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StudyManager.this.errorReporter.setTitle("Load Study List");
                StudyManager.this.studyListModel.setItems(StudyManager.this.getItems(StudyManager.this.errorReporter), true);
                StudyManager.this.lastListUpdate = System.currentTimeMillis();
                StudyManager.this.updateTimer.start();
                if (AppCore.maxEngineProcessCount < 1) {
                    StudyManager.this.errorReporter.setTitle("Study Runs Disabled");
                    if (AppCore.maxEngineProcessCount < 0) {
                        StudyManager.this.errorReporter.reportWarning("The study engine executable file is not properly installed\nEditing may occur however no study runs can be performed");
                    } else {
                        StudyManager.this.errorReporter.reportWarning("There is not enough memory for the study engine to run\nEditing may occur however no study runs can be performed");
                    }
                }
            }
        });
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        for (StudyLockHolder studyLockHolder : this.lockHolders.values()) {
            if (studyLockHolder instanceof RunPanel) continue;
            if (studyLockHolder instanceof AppFrame) {
                if (((AppFrame)((Object)studyLockHolder)).closeIfPossible()) continue;
                return false;
            }
            if (studyLockHolder instanceof AppDialog) {
                if (((AppDialog)((Object)studyLockHolder)).cancel()) continue;
                return false;
            }
            AppController.beep();
            studyLockHolder.toFront();
            return false;
        }
        if (null != this.stationDataViewer) {
            if (this.stationDataViewer.isVisible() && !this.stationDataViewer.closeIfPossible()) {
                return false;
            }
            this.stationDataViewer = null;
        }
        if (null != this.geographyEditor) {
            if (this.geographyEditor.isVisible() && !this.geographyEditor.closeIfPossible()) {
                return false;
            }
            this.geographyEditor.dispose();
            this.geographyEditor = null;
        }
        if (null != this.receiveAntennaEditor) {
            if (this.receiveAntennaEditor.isVisible() && !this.receiveAntennaEditor.closeIfPossible()) {
                return false;
            }
            this.receiveAntennaEditor.dispose();
            this.receiveAntennaEditor = null;
        }
        if (null != this.colorMapEditor) {
            if (this.colorMapEditor.isVisible() && !this.colorMapEditor.cancel()) {
                return false;
            }
            this.colorMapEditor.dispose();
            this.colorMapEditor = null;
        }
        if (null != this.studyBuildWizard) {
            if (this.studyBuildWizard.isVisible() && !this.studyBuildWizard.closeIfPossible()) {
                return false;
            }
            this.studyBuildWizard = null;
        }
        for (StudyLockHolder studyLockHolder : this.lockHolders.values()) {
            if (studyLockHolder.studyManagerClosing()) continue;
            AppController.beep();
            studyLockHolder.toFront();
            return false;
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        this.studyItemMap.clear();
        this.folderItemMap.clear();
        this.lockHolders.clear();
        DbController.saveColumnWidths(this.dbID, this.getKeyTitle(), this.studyListTable);
        this.blockActionsSet();
        this.updateTimer.stop();
        this.clearUpdateItems();
        if (null != this.updateThread) {
            while (this.updateThread.isAlive()) {
                try {
                    this.updateThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.updateThread = null;
        }
        this.clearUpdatedItems();
        managers.remove(this.dbID);
        DbCore.closeDb((String)this.dbID, (Object)this);
    }

    private class StudyCreateNew
    extends AppDialog
    implements ExtDbListener {
        private int recordType;
        private JTextField nameField;
        private KeyedRecordMenu templateMenu;
        private KeyedRecordMenu extDbMenu;
        private boolean canceled;
        private String studyName;
        private int templateKey;
        private Integer extDbKey;

        private StudyCreateNew(String string, int n) {
            super(StudyManager.this.outerThis, string, Dialog.ModalityType.APPLICATION_MODAL);
            this.recordType = n;
            this.nameField = new JTextField(20);
            AppController.fixKeyBindings(this.nameField);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Study Name"));
            jPanel.add(this.nameField);
            this.templateMenu = new KeyedRecordMenu();
            this.templateMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXyXyXyX"));
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Template"));
            jPanel2.add(this.templateMenu);
            this.extDbMenu = new KeyedRecordMenu();
            this.extDbMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXyXyXyX"));
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("Default Station Data"));
            jPanel3.add(this.extDbMenu);
            JButton jButton = new JButton("Create");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyCreateNew.this.doOK();
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.setFocusable(false);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyCreateNew.this.cancel();
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.add(jPanel);
            JPanel jPanel5 = new JPanel();
            jPanel5.add(jPanel2);
            jPanel5.add(jPanel3);
            JPanel jPanel6 = new JPanel(new FlowLayout(2));
            jPanel6.add(jButton2);
            jPanel6.add(jButton);
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(jPanel4);
            container.add(jPanel5);
            container.add(jPanel6);
            this.getRootPane().setDefaultButton(jButton);
            this.pack();
            this.setMinimumSize(this.getSize());
            this.setResizable(true);
            this.setLocationSaved(true);
        }

        @Override
        public void updateDocumentName() {
            this.setDocumentName(this.parent.getDocumentName());
        }

        private void doOK() {
            this.errorReporter.clearTitle();
            String string = this.nameField.getText().trim();
            if (!DbCore.checkStudyName((String)string, (String)StudyManager.this.dbID, (boolean)true, (ErrorLogger)this.errorReporter)) {
                return;
            }
            this.studyName = string;
            this.templateKey = this.templateMenu.getSelectedKey();
            if (this.templateKey <= 0) {
                this.errorReporter.reportWarning("Please choose a study template");
                return;
            }
            int n = this.extDbMenu.getSelectedKey();
            if (n > 0) {
                ExtDb extDb = ExtDb.getExtDb((String)StudyManager.this.dbID, (Integer)n);
                if (null == extDb || extDb.deleted) {
                    this.errorReporter.reportWarning("That station data set has been deleted, please select another");
                    return;
                }
                this.extDbKey = extDb.key;
            } else {
                this.extDbKey = null;
            }
            this.canceled = false;
            AppController.hideWindow(this);
        }

        @Override
        public boolean cancel() {
            this.canceled = true;
            AppController.hideWindow(this);
            return true;
        }

        public void updateExtDbList() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayList arrayList = ExtDb.getExtDbList((String)StudyManager.this.dbID, (int)StudyCreateNew.this.recordType);
                    if (null == arrayList) {
                        return;
                    }
                    int n = StudyCreateNew.this.extDbMenu.getSelectedKey();
                    StudyCreateNew.this.extDbMenu.removeAllItems();
                    StudyCreateNew.this.extDbMenu.addItem(new KeyedRecord(0, "(none)"));
                    if (!arrayList.isEmpty()) {
                        StudyCreateNew.this.extDbMenu.addAllItems(arrayList);
                    }
                    if (StudyCreateNew.this.extDbMenu.containsKey(n)) {
                        StudyCreateNew.this.extDbMenu.setSelectedKey(n);
                    }
                }
            });
        }

        @Override
        public void windowWillOpen() {
            this.studyName = "";
            this.templateKey = 0;
            this.extDbKey = null;
            this.nameField.setText("");
            this.nameField.requestFocusInWindow();
            this.templateMenu.removeAllItems();
            this.extDbMenu.removeAllItems();
            this.setLocationRelativeTo(this.getOwner());
            this.canceled = false;
            ExtDb.addListener((ExtDbListener)this);
            this.blockActionsClear();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StudyCreateNew.this.errorReporter.setTitle("Load Template List");
                    ArrayList arrayList = Template.getTemplateInfoList((String)StudyManager.this.dbID, (ErrorLogger)StudyCreateNew.this.errorReporter);
                    if (null != arrayList) {
                        StudyCreateNew.this.templateMenu.addAllItems(arrayList);
                    }
                    StudyCreateNew.this.errorReporter.setTitle("Load Station Data List");
                    StudyCreateNew.this.extDbMenu.addItem(new KeyedRecord(0, "(none)"));
                    arrayList = ExtDb.getExtDbList((String)StudyManager.this.dbID, (int)StudyCreateNew.this.recordType, (ErrorLogger)StudyCreateNew.this.errorReporter);
                    if (null != arrayList) {
                        StudyCreateNew.this.extDbMenu.addAllItems(arrayList);
                    }
                }
            });
        }

        @Override
        public boolean windowShouldClose() {
            this.canceled = true;
            return true;
        }

        @Override
        public void windowWillClose() {
            if (!this.isVisible()) {
                return;
            }
            ExtDb.removeListener((ExtDbListener)this);
            this.blockActionsSet();
        }
    }

    private class StudyListTableModel
    extends AbstractTableModel
    implements TableFilterModel {
        private static final String STUDY_NAME_COLUMN = "Name";
        private static final String STUDY_TYPE_COLUMN = "Type";
        private static final String STUDY_TEMPLATE_COLUMN = "Template";
        private static final String STUDY_EXT_DB_NAME_COLUMN = "Default Station Data";
        private static final String STUDY_CACHE_SIZE_COLUMN = "Cache Size";
        private String[] columnNames = new String[]{"Name", "Type", "Template", "Default Station Data", "Cache Size"};
        private static final int STUDY_NAME_INDEX = 0;
        private static final int STUDY_TYPE_INDEX = 1;
        private static final int STUDY_TEMPLATE_INDEX = 2;
        private static final int STUDY_EXT_DB_NAME_INDEX = 3;
        private static final int STUDY_CACHE_SIZE_INDEX = 4;
        private ArrayList<StudyListItem> modelRows = new ArrayList();
        private TableFilterPanel filterPanel;

        private StudyListTableModel() {
            this.filterPanel = new TableFilterPanel((AppEditor)StudyManager.this.outerThis, this);
        }

        private JTable createTable(EditMenu editMenu) {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable, editMenu);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    StudyListItem studyListItem = (StudyListItem)StudyListTableModel.this.modelRows.get(((StudyListTableModel)StudyListTableModel.this).filterPanel.forwardIndex[jTable.convertRowIndexToModel(n)]);
                    if (studyListItem.isFolder) {
                        if (!bl) {
                            jLabel.setForeground(Color.MAGENTA);
                        }
                        jLabel.setToolTipText(null);
                        return jLabel;
                    }
                    StudyLockHolder studyLockHolder = (StudyLockHolder)StudyManager.this.lockHolders.get(studyListItem.key);
                    if (!bl) {
                        if (null != studyLockHolder) {
                            switch (studyLockHolder.getStudyLock()) {
                                default: {
                                    jLabel.setForeground(Color.BLACK);
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    jLabel.setForeground(Color.GREEN.darker());
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    jLabel.setForeground(Color.RED);
                                    break;
                                }
                            }
                        } else if (0 != studyListItem.studyLock) {
                            jLabel.setForeground(Color.GRAY);
                        } else {
                            jLabel.setForeground(Color.BLACK);
                        }
                    }
                    int n3 = jTable.convertColumnIndexToModel(n2);
                    String string = studyListItem.description.trim();
                    if (0 == n3 && string.length() > 0) {
                        if (!bl) {
                            jLabel.setForeground(Color.BLUE);
                        }
                        String[] stringArray = string.split("\\s+");
                        boolean bl3 = false;
                        StringBuilder stringBuilder = new StringBuilder();
                        int n4 = 0;
                        for (int i = 0; i < stringArray.length; ++i) {
                            int n5 = stringArray[i].length();
                            if (n5 <= 0) continue;
                            if (!bl3) {
                                stringBuilder.append("<HTML>");
                                bl3 = true;
                            }
                            stringBuilder.append(stringArray[i]);
                            if ((n4 += n5) > 35) {
                                stringBuilder.append("<BR>");
                                n4 = 0;
                                continue;
                            }
                            stringBuilder.append(" ");
                        }
                        if (bl3) {
                            stringBuilder.append("</HTML>");
                            jLabel.setToolTipText(stringBuilder.toString());
                        } else {
                            jLabel.setToolTipText(null);
                        }
                    } else {
                        jLabel.setToolTipText(null);
                    }
                    return jLabel;
                }
            };
            TableColumn tableColumn = jTable.getColumn(STUDY_NAME_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[16]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[25]);
            tableColumn = jTable.getColumn(STUDY_TYPE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[12]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[16]);
            tableColumn = jTable.getColumn(STUDY_TEMPLATE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[10]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[14]);
            tableColumn = jTable.getColumn(STUDY_EXT_DB_NAME_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[14]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[18]);
            tableColumn = jTable.getColumn(STUDY_CACHE_SIZE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            TableStringConverter tableStringConverter = new TableStringConverter(){

                @Override
                public String toString(TableModel tableModel, int n, int n2) {
                    StudyListItem studyListItem = (StudyListItem)StudyListTableModel.this.modelRows.get(((StudyListTableModel)StudyListTableModel.this).filterPanel.forwardIndex[n]);
                    if (studyListItem.isFolder) {
                        switch (n2) {
                            case 0: {
                                return studyListItem.name;
                            }
                            case 1: {
                                if (studyListItem.isLink) {
                                    return "";
                                }
                                return String.format("0%06d", studyListItem.items.size());
                            }
                        }
                    } else {
                        switch (n2) {
                            case 0: {
                                return studyListItem.name;
                            }
                            case 1: {
                                return String.format("1%06d", studyListItem.studyType);
                            }
                            case 2: {
                                return studyListItem.templateName;
                            }
                            case 3: {
                                return studyListItem.extDbName;
                            }
                            case 4: {
                                return String.format(Locale.US, "%018d", studyListItem.getCacheSize());
                            }
                        }
                    }
                    return "";
                }
            };
            TableRowSorter<StudyListTableModel> tableRowSorter = new TableRowSorter<StudyListTableModel>(this);
            tableRowSorter.setStringConverter(tableStringConverter);
            jTable.setRowSorter(tableRowSorter);
            return jTable;
        }

        private void setItems(ArrayList<StudyListItem> arrayList, boolean bl) {
            this.modelRows.clear();
            if (null == arrayList) {
                this.filterPanel.clearFilter();
                this.fireTableDataChanged();
                return;
            }
            if (StudyManager.this.currentFolderKey > 0) {
                StudyListItem studyListItem = new StudyListItem();
                studyListItem.isFolder = true;
                studyListItem.isLink = true;
                studyListItem.folderKey = 0;
                studyListItem.name = "(back)";
                StudyListItem studyListItem2 = (StudyListItem)StudyManager.this.folderItemMap.get(StudyManager.this.currentFolderKey);
                if (null != studyListItem2 && null != (studyListItem2 = (StudyListItem)StudyManager.this.folderItemMap.get(studyListItem2.parentFolderKey))) {
                    studyListItem.folderKey = studyListItem2.folderKey;
                    studyListItem.name = "(back to " + studyListItem2.name + ")";
                }
                this.modelRows.add(studyListItem);
            }
            for (StudyListItem studyListItem2 : arrayList) {
                this.modelRows.add(studyListItem2);
                if (studyListItem2.isFolder || !studyListItem2.isCacheSizeExpired()) continue;
                StudyManager.this.addUpdateItem(studyListItem2);
            }
            if (bl) {
                this.filterPanel.clearFilter();
            } else {
                this.filterPanel.updateFilter();
            }
            this.fireTableDataChanged();
        }

        @Override
        public void filterDidChange() {
            this.fireTableDataChanged();
        }

        private void itemWasChanged(int n) {
            this.fireTableRowsUpdated(n, n);
        }

        private void itemWasChanged(StudyListItem studyListItem) {
            int n = this.indexOf(studyListItem);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        private int indexOf(StudyListItem studyListItem) {
            int n = 0;
            for (StudyListItem studyListItem2 : this.modelRows) {
                if (studyListItem2.isFolder ? !studyListItem2.isLink && studyListItem.isFolder && studyListItem2.folderKey.equals(studyListItem.folderKey) : !studyListItem.isFolder && studyListItem2.key.equals(studyListItem.key)) {
                    return this.filterPanel.reverseIndex[n];
                }
                ++n;
            }
            return -1;
        }

        private int indexOfStudy(Integer n) {
            int n2 = 0;
            for (StudyListItem studyListItem : this.modelRows) {
                if (!studyListItem.isFolder && studyListItem.key.equals(n)) {
                    return this.filterPanel.reverseIndex[n2];
                }
                ++n2;
            }
            return -1;
        }

        private StudyListItem get(int n) {
            return this.modelRows.get(this.filterPanel.forwardIndex[n]);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public boolean filterByColumn(int n) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean collapseFilterChoices(int n) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.filterPanel.forwardIndex.length;
        }

        @Override
        public int getUnfilteredRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.getCellValue(this.filterPanel.forwardIndex[n], n2, false);
        }

        @Override
        public String getUnfilteredValueAt(int n, int n2) {
            return this.getCellValue(n, n2, true);
        }

        private String getCellValue(int n, int n2, boolean bl) {
            StudyListItem studyListItem = this.modelRows.get(n);
            if (studyListItem.isFolder) {
                switch (n2) {
                    case 0: {
                        return studyListItem.name;
                    }
                    case 1: {
                        if (studyListItem.isLink) {
                            return "";
                        }
                        if (bl) {
                            return "Folder";
                        }
                        return "Folder (" + studyListItem.items.size() + " items)";
                    }
                }
            } else {
                switch (n2) {
                    case 0: {
                        return studyListItem.name;
                    }
                    case 1: {
                        return Study.getStudyTypeName((int)studyListItem.studyType);
                    }
                    case 2: {
                        return studyListItem.templateName;
                    }
                    case 3: {
                        return studyListItem.extDbName;
                    }
                    case 4: {
                        return AppCore.formatBytes((long)studyListItem.getCacheSize());
                    }
                }
            }
            return "";
        }
    }

    private class StudyListItem {
        private Integer key;
        private String name;
        private boolean isFolder;
        private boolean isLink;
        private Integer folderKey;
        private Integer parentFolderKey;
        private ArrayList<StudyListItem> items;
        private String description;
        private int studyLock;
        private int lockCount;
        private int studyType;
        private String templateName;
        private String extDbName;
        private boolean hasResultTables;
        private String outDirectory;
        private String created;
        private String modified;
        private String lastRun;
        private long cacheSize;
        private long lastCacheCheck;

        private StudyListItem() {
        }

        private synchronized long getCacheSize() {
            return this.cacheSize;
        }

        private synchronized boolean isCacheSizeExpired() {
            if (this.isFolder) {
                return false;
            }
            return System.currentTimeMillis() - this.lastCacheCheck > 600000L;
        }

        private void updateCacheSize() {
            if (this.isFolder) {
                return;
            }
            this.setCacheSize(AppCore.getStudyCacheSize((String)StudyManager.this.dbID, (int)this.key));
        }

        private synchronized void setCacheSize(long l) {
            if (this.isFolder) {
                return;
            }
            this.cacheSize = l;
            this.lastCacheCheck = System.currentTimeMillis();
        }

        private synchronized void clearCacheSize() {
            if (this.isFolder) {
                return;
            }
            this.cacheSize = -1L;
            this.lastCacheCheck = 0L;
        }
    }
}

