/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.RootEditor;
import java.awt.Color;
import java.awt.Dialog;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SourceCompare
extends AppDialog {
    private static SourceCompare sourceCompare;
    private SourceEditData.RecordData referenceData;
    private SourceEditData.RecordData compare1Data;
    private SourceEditData.RecordData compare2Data;
    private JPanel panel;
    private GroupLayout layout;
    private ArrayList<JLabel> compare1Labels;
    private ArrayList<JLabel> compare2Labels;
    private GroupLayout.ParallelGroup labelGroup;
    private GroupLayout.ParallelGroup referenceGroup;
    private GroupLayout.ParallelGroup compare1Group;
    private GroupLayout.ParallelGroup compare2Group;
    private GroupLayout.SequentialGroup verticalGroup;
    private int labelIndex;

    private SourceCompare() {
        super(null, null, "Compare Records", Dialog.ModalityType.MODELESS);
        if (null != sourceCompare) {
            throw new RuntimeException("Comparison manager already exists");
        }
        sourceCompare = this;
        this.panel = new JPanel();
        this.add(AppController.createScrollPane(this.panel));
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return null;
    }

    @Override
    public RootEditor getRootEditor() {
        return null;
    }

    public static boolean compare(SourceEditData sourceEditData, ErrorReporter errorReporter) {
        SourceEditData.RecordData recordData = sourceEditData.getRecordData((ErrorLogger)errorReporter);
        if (null == recordData) {
            return false;
        }
        SourceCompare.compare(recordData);
        return true;
    }

    public static boolean compare(ExtDbRecord extDbRecord, ErrorReporter errorReporter) {
        SourceEditData sourceEditData = SourceEditData.makeSource((ExtDbRecord)extDbRecord, null, (boolean)true, (ErrorLogger)errorReporter);
        if (null == sourceEditData) {
            return false;
        }
        SourceEditData.RecordData recordData = sourceEditData.getRecordData((ErrorLogger)errorReporter);
        if (null == recordData) {
            return false;
        }
        SourceCompare.compare(recordData);
        return true;
    }

    public static void compare(SourceEditData.RecordData recordData) {
        if (null == sourceCompare) {
            new SourceCompare();
        }
        if (sourceCompare.isVisible()) {
            if (null != SourceCompare.sourceCompare.compare1Data) {
                SourceCompare.sourceCompare.compare2Data = SourceCompare.sourceCompare.compare1Data;
            }
            SourceCompare.sourceCompare.compare1Data = recordData;
            sourceCompare.updateAll();
            sourceCompare.toFront();
        } else {
            SourceCompare.sourceCompare.referenceData = recordData;
            SourceCompare.sourceCompare.compare1Data = null;
            SourceCompare.sourceCompare.compare2Data = null;
            sourceCompare.newLayout();
            AppController.showWindow(sourceCompare);
        }
    }

    private void newLayout() {
        JPanel jPanel = new JPanel();
        this.layout = new GroupLayout(jPanel);
        jPanel.setLayout(this.layout);
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        this.labelGroup = this.layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        this.referenceGroup = this.layout.createParallelGroup();
        this.compare1Group = this.layout.createParallelGroup();
        this.compare2Group = this.layout.createParallelGroup();
        this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGroup(this.labelGroup).addGroup(this.referenceGroup).addGroup(this.compare1Group).addGroup(this.compare2Group));
        this.verticalGroup = this.layout.createSequentialGroup();
        this.layout.setVerticalGroup(this.verticalGroup);
        this.compare1Labels = new ArrayList();
        this.compare2Labels = new ArrayList();
        for (String string : this.referenceData.propertyValues.keySet()) {
            this.layoutOne((String)SourceEditData.RecordData.propertyNames.get(string), (String)this.referenceData.propertyValues.get(string));
        }
        if (null != this.referenceData.horizontalPattern) {
            this.layoutOne("Horizontal pattern data", "");
        }
        if (null != this.referenceData.verticalPattern) {
            this.layoutOne("Vertical pattern data", "");
        }
        if (null != this.referenceData.dependentData) {
            for (Integer n : this.referenceData.dependentData.keySet()) {
                String string;
                JLabel jLabel = new JLabel("Site " + String.valueOf(n));
                this.labelGroup.addComponent(jLabel);
                this.verticalGroup.addComponent(jLabel);
                string = (SourceEditData.RecordData)this.referenceData.dependentData.get(n);
                for (String string2 : ((SourceEditData.RecordData)string).propertyValues.keySet()) {
                    this.layoutOne((String)SourceEditData.RecordData.propertyNames.get(string2), (String)((SourceEditData.RecordData)string).propertyValues.get(string2));
                }
                if (null != ((SourceEditData.RecordData)string).horizontalPattern) {
                    this.layoutOne("Horizontal pattern data", "");
                }
                if (null == ((SourceEditData.RecordData)string).verticalPattern) continue;
                this.layoutOne("Vertical pattern data", "");
            }
        }
        this.panel.removeAll();
        this.panel.add(jPanel);
        this.pack();
    }

    private void layoutOne(String string, String string2) {
        JLabel jLabel = new JLabel(string);
        JLabel jLabel2 = new JLabel(string2);
        JLabel jLabel3 = new JLabel(" ");
        jLabel3.setOpaque(true);
        jLabel3.setPreferredSize(jLabel2.getSize());
        this.compare1Labels.add(jLabel3);
        JLabel jLabel4 = new JLabel(" ");
        jLabel4.setPreferredSize(jLabel2.getSize());
        jLabel4.setOpaque(true);
        this.compare2Labels.add(jLabel4);
        this.labelGroup.addComponent(jLabel);
        this.referenceGroup.addComponent(jLabel2);
        this.compare1Group.addComponent(jLabel3);
        this.compare2Group.addComponent(jLabel4);
        this.verticalGroup.addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(jLabel2).addComponent(jLabel3).addComponent(jLabel4));
    }

    private void updateAll() {
        if (!this.isVisible()) {
            return;
        }
        this.labelIndex = 0;
        this.updateOne(this.referenceData, this.compare1Data, this.compare2Data);
        if (null != this.referenceData.dependentData) {
            SourceEditData.RecordData recordData = null;
            SourceEditData.RecordData recordData2 = null;
            for (Integer n : this.referenceData.dependentData.keySet()) {
                SourceEditData.RecordData recordData3 = (SourceEditData.RecordData)this.referenceData.dependentData.get(n);
                if (null != this.compare1Data && null != this.compare1Data.dependentData) {
                    recordData = (SourceEditData.RecordData)this.compare1Data.dependentData.get(n);
                }
                if (null != this.compare2Data && null != this.compare2Data.dependentData) {
                    recordData2 = (SourceEditData.RecordData)this.compare2Data.dependentData.get(n);
                }
                this.updateOne(recordData3, recordData, recordData2);
            }
        }
    }

    private void updateOne(SourceEditData.RecordData recordData, SourceEditData.RecordData recordData2, SourceEditData.RecordData recordData3) {
        JLabel jLabel;
        Color color;
        String string;
        JLabel jLabel2;
        Color color2;
        String string2;
        Color color3 = AppController.DISABLED_TEXT_BACKGROUND;
        Color color4 = Color.PINK;
        for (String string3 : recordData.propertyValues.keySet()) {
            String string4 = (String)recordData.propertyValues.get(string3);
            if (null != this.compare1Data) {
                if (null != recordData2) {
                    string2 = (String)recordData2.propertyValues.get(string3);
                    if (null == string2) {
                        string2 = "";
                        color2 = color4;
                    } else {
                        color2 = string4.equals(string2) ? color3 : color4;
                    }
                } else {
                    string2 = "";
                    color2 = color4;
                }
                jLabel2 = this.compare1Labels.get(this.labelIndex);
                jLabel2.setText(string2);
                jLabel2.setBackground(color2);
            }
            if (null != this.compare2Data) {
                if (null != recordData3) {
                    string = (String)recordData3.propertyValues.get(string3);
                    if (null == string) {
                        string = "";
                        color = color4;
                    } else {
                        color = string4.equals(string) ? color3 : color4;
                    }
                } else {
                    string = "";
                    color = color4;
                }
                jLabel = this.compare2Labels.get(this.labelIndex);
                jLabel.setText(string);
                jLabel.setBackground(color);
            }
            ++this.labelIndex;
        }
        if (null != recordData.horizontalPattern) {
            if (null != this.compare1Data) {
                if (null != recordData2) {
                    if (null == recordData2.horizontalPattern) {
                        string2 = "No pattern";
                        color2 = color4;
                    } else if (recordData.horizontalPattern.equalsPattern(recordData2.horizontalPattern)) {
                        string2 = "Match";
                        color2 = color3;
                    } else {
                        string2 = "Does not match";
                        color2 = color4;
                    }
                } else {
                    string2 = "";
                    color2 = color4;
                }
                jLabel2 = this.compare1Labels.get(this.labelIndex);
                jLabel2.setText(string2);
                jLabel2.setBackground(color2);
            }
            if (null != this.compare2Data) {
                if (null != recordData3) {
                    if (null == recordData3.horizontalPattern) {
                        string = "No pattern";
                        color = color4;
                    } else if (recordData.horizontalPattern.equalsPattern(recordData3.horizontalPattern)) {
                        string = "Match";
                        color = color3;
                    } else {
                        string = "Does not match";
                        color = color4;
                    }
                } else {
                    string = "";
                    color = color4;
                }
                jLabel = this.compare2Labels.get(this.labelIndex);
                jLabel.setText(string);
                jLabel.setBackground(color);
            }
            ++this.labelIndex;
        }
        if (null != recordData.verticalPattern) {
            if (null != this.compare1Data) {
                if (null != recordData2) {
                    if (null == recordData2.verticalPattern) {
                        string2 = "No pattern";
                        color2 = color4;
                    } else if (recordData.verticalPattern.equalsPattern(recordData2.verticalPattern)) {
                        string2 = "Match";
                        color2 = color3;
                    } else {
                        string2 = "Does not match";
                        color2 = color4;
                    }
                } else {
                    string2 = "";
                    color2 = color4;
                }
                jLabel2 = this.compare1Labels.get(this.labelIndex);
                jLabel2.setText(string2);
                jLabel2.setBackground(color2);
            }
            if (null != this.compare2Data) {
                if (null != recordData3) {
                    if (null == recordData3.verticalPattern) {
                        string = "No pattern";
                        color = color4;
                    } else if (recordData.verticalPattern.equalsPattern(recordData3.verticalPattern)) {
                        string = "Match";
                        color = color3;
                    } else {
                        string = "Does not match";
                        color = color4;
                    }
                } else {
                    string = "";
                    color = color4;
                }
                jLabel = this.compare2Labels.get(this.labelIndex);
                jLabel.setText(string);
                jLabel.setBackground(color);
            }
            ++this.labelIndex;
        }
    }

    @Override
    public void windowWillOpen() {
        this.blockActionsClear();
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        this.panel.removeAll();
        this.referenceData = null;
        this.compare1Data = null;
        this.compare2Data = null;
        this.blockActionsSet();
    }
}

