/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.RecordFindPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class RecordFindDialog
extends AppDialog {
    public static final String WINDOW_TITLE = "Search Station Data";
    private RecordFindPanel findPanel;
    private JButton okButton;
    public boolean canceled;
    private RecordFindDialog outerThis = this;

    public RecordFindDialog(AppEditor appEditor, int n) {
        super(appEditor, WINDOW_TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.doSetup(n);
    }

    public RecordFindDialog(AppEditor appEditor, String string, int n) {
        super(appEditor, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.doSetup(n);
    }

    private void doSetup(int n) {
        this.findPanel = new RecordFindPanel((AppEditor)this, new Runnable(){

            @Override
            public void run() {
                RecordFindDialog.this.findPanelSelectionChanged();
            }
        }, n, false);
        this.okButton = new JButton("OK");
        this.okButton.setFocusable(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppController.hideWindow(RecordFindDialog.this.outerThis);
            }
        });
        this.okButton.setEnabled(false);
        JButton jButton = new JButton("Cancel");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordFindDialog.this.canceled = true;
                AppController.hideWindow(RecordFindDialog.this.outerThis);
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        jPanel.add(this.okButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.findPanel, "Center");
        container.add((Component)jPanel, "South");
        this.getRootPane().setDefaultButton(this.findPanel.getDefaultButton());
        this.pack();
        this.setResizable(true);
        Dimension dimension = new Dimension(1170, 500);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setLocationRelativeTo(this.getOwner());
        this.updateDocumentName();
    }

    public void setDefaultExtDbKey(Integer n) {
        this.findPanel.setDefaultExtDbKey(n);
    }

    public void setTVChannelRange(int n, int n2) {
        this.findPanel.setTVChannelRange(n, n2);
    }

    public void setNote(String string) {
        this.findPanel.setNote(string);
    }

    public void setStudy(StudyEditData studyEditData) {
        this.findPanel.setStudy(studyEditData);
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
        this.findPanel.updateDocumentName();
    }

    public void findPanelSelectionChanged() {
        this.okButton.setEnabled(null != this.findPanel.getSelectedRecord());
    }

    public StationRecord getSelectedRecord() {
        return this.findPanel.getSelectedRecord();
    }

    @Override
    public void windowWillOpen() {
        this.findPanel.windowWillOpen();
        this.blockActionsClear();
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        if (!this.findPanel.windowShouldClose()) {
            return false;
        }
        this.canceled = true;
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        this.findPanel.windowWillClose();
        this.blockActionsSet();
    }
}

