/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbListener;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class PickExtDbDialog
extends AppDialog
implements ExtDbListener {
    private ArrayList<KeyedRecord> extDbList;
    private KeyedRecordMenu lookupExtDbMenu = new KeyedRecordMenu();
    private KeyedRecordMenu alternateExtDbMenu;
    public int lookupExtDbKey;
    public int alternateExtDbKey;
    public boolean canceled;

    public PickExtDbDialog(AppEditor appEditor, String string, Integer n) {
        super(appEditor, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.lookupExtDbMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PickExtDbDialog.this.blockActions()) {
                    PickExtDbDialog.this.lookupExtDbKey = PickExtDbDialog.this.lookupExtDbMenu.getSelectedKey();
                    PickExtDbDialog.this.updateMenu();
                    PickExtDbDialog.this.blockActionsEnd();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.lookupExtDbMenu);
        jPanel.setBorder(BorderFactory.createTitledBorder("Primary"));
        this.alternateExtDbMenu = new KeyedRecordMenu();
        this.alternateExtDbMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PickExtDbDialog.this.alternateExtDbKey = PickExtDbDialog.this.alternateExtDbMenu.getSelectedKey();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.alternateExtDbMenu);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Alternate"));
        JLabel jLabel = new JLabel("<HTML>Select data sets to resolve references to station data records by ID.<BR>If no data sets are selected, by-reference elements are ignored.  Alternate<BR>data will be search when a record is not found in the primary data.</HTML>");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jLabel);
        JButton jButton = new JButton("OK");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PickExtDbDialog.this.doOK();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PickExtDbDialog.this.cancel();
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jPanel2);
        Box box = Box.createVerticalBox();
        box.add(jPanel4);
        box.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 20));
        jPanel6.add(jPanel3);
        jPanel6.add(Box.createVerticalStrut(10));
        jPanel6.add(box);
        jPanel6.add(Box.createVerticalStrut(10));
        JPanel jPanel7 = new JPanel(new FlowLayout(2));
        jPanel7.add(jButton2);
        jPanel7.add(jButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel6, "Center");
        container.add((Component)jPanel7, "South");
        this.pack();
        this.setLocationRelativeTo(appEditor.getWindow());
        if (null != n) {
            this.lookupExtDbKey = n;
        }
    }

    private void updateMenu() {
        this.alternateExtDbMenu.removeAllItems();
        this.alternateExtDbMenu.addItem(new KeyedRecord(0, "(none)"));
        if (this.lookupExtDbKey > 0) {
            for (KeyedRecord keyedRecord : this.extDbList) {
                if (keyedRecord.key == this.lookupExtDbKey) continue;
                this.alternateExtDbMenu.addItem(keyedRecord);
            }
            AppController.setComponentEnabled(this.alternateExtDbMenu, true);
            if (this.alternateExtDbMenu.containsKey(this.alternateExtDbKey)) {
                this.alternateExtDbMenu.setSelectedKey(this.alternateExtDbKey);
            } else {
                this.alternateExtDbKey = this.alternateExtDbMenu.getSelectedKey();
            }
        } else {
            AppController.setComponentEnabled(this.alternateExtDbMenu, false);
            this.alternateExtDbKey = 0;
        }
    }

    private void doOK() {
        AppController.hideWindow(this);
    }

    @Override
    public boolean cancel() {
        this.canceled = true;
        AppController.hideWindow(this);
        return true;
    }

    protected abstract ArrayList<KeyedRecord> getExtDbList(ErrorReporter var1);

    public void updateExtDbList() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList<KeyedRecord> arrayList = PickExtDbDialog.this.getExtDbList(null);
                if (null == arrayList) {
                    return;
                }
                PickExtDbDialog.this.extDbList = arrayList;
                PickExtDbDialog.this.blockActionsStart();
                PickExtDbDialog.this.lookupExtDbMenu.removeAllItems();
                PickExtDbDialog.this.lookupExtDbMenu.addAllItems(PickExtDbDialog.this.extDbList);
                PickExtDbDialog.this.lookupExtDbMenu.addItem(new KeyedRecord(0, "(none)"));
                if (PickExtDbDialog.this.lookupExtDbMenu.containsKey(PickExtDbDialog.this.lookupExtDbKey)) {
                    PickExtDbDialog.this.lookupExtDbMenu.setSelectedKey(PickExtDbDialog.this.lookupExtDbKey);
                } else {
                    PickExtDbDialog.this.lookupExtDbKey = PickExtDbDialog.this.lookupExtDbMenu.getSelectedKey();
                }
                PickExtDbDialog.this.updateMenu();
                PickExtDbDialog.this.blockActionsEnd();
            }
        });
    }

    @Override
    public void windowWillOpen() {
        this.lookupExtDbMenu.removeAllItems();
        this.alternateExtDbMenu.removeAllItems();
        this.blockActionsClear();
        ExtDb.addListener((ExtDbListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PickExtDbDialog.this.extDbList = PickExtDbDialog.this.getExtDbList(PickExtDbDialog.this.errorReporter);
                if (null == PickExtDbDialog.this.extDbList) {
                    PickExtDbDialog.this.cancel();
                }
                PickExtDbDialog.this.blockActionsStart();
                PickExtDbDialog.this.lookupExtDbMenu.addAllItems(PickExtDbDialog.this.extDbList);
                PickExtDbDialog.this.lookupExtDbMenu.addItem(new KeyedRecord(0, "(none)"));
                if (PickExtDbDialog.this.lookupExtDbKey > 0 && PickExtDbDialog.this.lookupExtDbMenu.containsKey(PickExtDbDialog.this.lookupExtDbKey)) {
                    PickExtDbDialog.this.lookupExtDbMenu.setSelectedKey(PickExtDbDialog.this.lookupExtDbKey);
                } else {
                    PickExtDbDialog.this.lookupExtDbKey = PickExtDbDialog.this.lookupExtDbMenu.getSelectedKey();
                }
                PickExtDbDialog.this.updateMenu();
                PickExtDbDialog.this.blockActionsEnd();
            }
        });
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        ExtDb.removeListener((ExtDbListener)this);
        this.blockActionsSet();
    }
}

