/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.ColorMap;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.OutputConfig;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class OutputConfigDialog
extends AppDialog {
    public static final String WINDOW_TITLE = "Output Settings";
    private ArrayList<OutputConfig> configs;
    private boolean showNullObject;
    private ArrayList<ConfigPanel> configPanels;
    private KeyedRecordMenu colorMapMenu;
    private JLabel colorMapLabel;
    private int colorMapKey;
    private OutputConfigDialog outerThis = this;

    public OutputConfigDialog(AppEditor appEditor) {
        super(appEditor, WINDOW_TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.doSetup(null, false, false);
    }

    public OutputConfigDialog(AppEditor appEditor, ArrayList<OutputConfig> arrayList, boolean bl) {
        super(appEditor, WINDOW_TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.doSetup(arrayList, true, bl);
    }

    /*
     * WARNING - void declaration
     */
    private void doSetup(ArrayList<OutputConfig> arrayList, boolean bl, boolean bl2) {
        JComponent jComponent;
        this.configs = new ArrayList();
        if (null != arrayList) {
            for (OutputConfig object2 : arrayList) {
                if (null == object2) continue;
                this.configs.add(object2);
            }
        }
        if (this.configs.isEmpty()) {
            this.configs.add(OutputConfig.getLastUsed((String)this.getDbID(), (int)1));
            this.configs.add(OutputConfig.getLastUsed((String)this.getDbID(), (int)2));
        }
        this.colorMapMenu = new KeyedRecordMenu();
        this.colorMapLabel = new JLabel();
        this.configPanels = new ArrayList();
        for (OutputConfig outputConfig : this.configs) {
            if (outputConfig.isNull()) {
                this.configPanels.add(new ConfigPanel(outputConfig.type, OutputConfig.getDefaultObject((int)outputConfig.type)));
                continue;
            }
            this.configPanels.add(new ConfigPanel(outputConfig.type, outputConfig));
        }
        this.showNullObject = bl2;
        JButton jButton = new JButton("OK");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputConfigDialog.this.doOK();
            }
        });
        Object var5_8 = null;
        if (bl) {
            JButton jButton2 = new JButton("Cancel");
            jButton2.setFocusable(false);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutputConfigDialog.this.cancel();
                }
            });
        }
        Container container = null;
        if (this.configPanels.size() == 1) {
            container = this.configPanels.get(0);
        } else {
            jComponent = new JTabbedPane();
            for (ConfigPanel configPanel : this.configPanels) {
                ((JTabbedPane)jComponent).addTab(OutputConfig.getTypeName((int)configPanel.type), configPanel);
            }
            container = jComponent;
        }
        jComponent = new JPanel(new FlowLayout(2));
        if (bl) {
            void var5_10;
            jComponent.add((Component)var5_10);
        }
        jComponent.add(jButton);
        Container container2 = this.getContentPane();
        container2.setLayout(new BorderLayout());
        container2.add((Component)container, "Center");
        container2.add((Component)jComponent, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(true);
        this.updateMenus();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    private void updateMenus() {
        for (ConfigPanel configPanel : this.configPanels) {
            configPanel.updateMenu();
        }
    }

    private boolean validateInputs() {
        for (ConfigPanel configPanel : this.configPanels) {
            if (configPanel.validateInput()) continue;
            return false;
        }
        return true;
    }

    private void doOK() {
        if (!this.validateInputs()) {
            return;
        }
        this.configs = new ArrayList();
        for (ConfigPanel configPanel : this.configPanels) {
            this.configs.add(configPanel.config);
        }
        this.blockActionsSet();
        AppController.hideWindow(this);
    }

    private void doCancel() {
        ArrayList<OutputConfig> arrayList = this.configs;
        this.configs = new ArrayList();
        for (OutputConfig outputConfig : arrayList) {
            OutputConfig outputConfig2;
            if (outputConfig.isUnsaved() || outputConfig.isNull()) {
                outputConfig2 = outputConfig;
            } else {
                outputConfig2 = OutputConfig.getConfig((String)this.getDbID(), (int)outputConfig.type, (String)outputConfig.name);
                if (null == outputConfig2) {
                    outputConfig2 = outputConfig;
                }
            }
            this.configs.add(outputConfig2);
        }
    }

    @Override
    public boolean cancel() {
        if (!this.isVisible()) {
            return true;
        }
        this.doCancel();
        AppController.hideWindow(this);
        return true;
    }

    public ArrayList<OutputConfig> getConfigs() {
        return this.configs;
    }

    @Override
    public void windowWillOpen() {
        this.setLocationRelativeTo(this.getOwner());
        this.blockActionsClear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OutputConfigDialog.this.blockActionsStart();
                OutputConfigDialog.this.colorMapMenu.removeAllItems();
                ArrayList arrayList = ColorMap.getColorMaps((String)OutputConfigDialog.this.getDbID(), (ErrorLogger)OutputConfigDialog.this.errorReporter);
                if (null != arrayList) {
                    OutputConfigDialog.this.colorMapMenu.addAllItems(arrayList);
                    if (OutputConfigDialog.this.colorMapMenu.containsKey(OutputConfigDialog.this.colorMapKey)) {
                        OutputConfigDialog.this.colorMapMenu.setSelectedKey(OutputConfigDialog.this.colorMapKey);
                    }
                }
                OutputConfigDialog.this.blockActionsEnd();
            }
        });
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        this.doCancel();
        return true;
    }

    @Override
    public void windowWillClose() {
        this.blockActionsSet();
    }

    private class ConfigPanel
    extends JPanel {
        private int type;
        private JComboBox<OutputConfig> configMenu;
        private JButton deleteButton;
        private ArrayList<FlagPanel> flagPanels;
        private ArrayList<FlagPanel> enablingFlagPanels;
        private JTextField nameField;
        private JButton saveButton;
        private OutputConfig config;

        private ConfigPanel(int n, OutputConfig outputConfig) {
            this.type = n;
            this.config = outputConfig;
            this.configMenu = new JComboBox();
            this.configMenu.setFocusable(false);
            this.configMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OutputConfigDialog.this.blockActions()) {
                        OutputConfig outputConfig = (OutputConfig)ConfigPanel.this.configMenu.getSelectedItem();
                        if (null != outputConfig) {
                            ConfigPanel.this.config = outputConfig;
                            ConfigPanel.this.updateConfig();
                        }
                        OutputConfigDialog.this.blockActionsEnd();
                    }
                }
            });
            this.deleteButton = new JButton("Delete");
            this.deleteButton.setFocusable(false);
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigPanel.this.doDelete();
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(this.configMenu);
            jPanel.add(this.deleteButton);
            this.flagPanels = new ArrayList();
            this.enablingFlagPanels = new ArrayList();
            String[][] stringArray = OutputConfig.getFlagNames((int)this.type);
            String[] stringArray2 = OutputConfig.getFlagGroups((int)this.type);
            int[][] nArray = OutputConfig.getFlagList((int)this.type);
            JTabbedPane jTabbedPane = new JTabbedPane();
            for (int i = 0; i < stringArray2.length; ++i) {
                Box box = Box.createVerticalBox();
                JPanel jPanel2 = new JPanel();
                jPanel2.add(box);
                jTabbedPane.addTab(stringArray2[i], jPanel2);
                FlagPanel flagPanel = null;
                for (int n2 : nArray[i]) {
                    FlagPanel flagPanel2;
                    if (n2 < 0) {
                        flagPanel2 = new FlagPanel(-n2, stringArray[-n2]);
                        this.enablingFlagPanels.add(flagPanel2);
                        flagPanel = flagPanel2;
                    } else {
                        flagPanel2 = new FlagPanel(n2, stringArray[n2]);
                        if (null != flagPanel) {
                            flagPanel.addEnablesFlag(flagPanel2);
                        } else {
                            this.enablingFlagPanels.add(flagPanel2);
                        }
                    }
                    this.flagPanels.add(flagPanel2);
                    box.add(flagPanel2);
                }
            }
            this.nameField = new JTextField(20);
            AppController.fixKeyBindings(this.nameField);
            this.saveButton = new JButton("Save");
            this.saveButton.setFocusable(false);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigPanel.this.doSave();
                }
            });
            JPanel jPanel3 = new JPanel();
            jPanel3.add(this.nameField);
            jPanel3.add(this.saveButton);
            Object object = Box.createVerticalBox();
            ((Container)object).add(jPanel);
            ((Container)object).add(jPanel3);
            this.setLayout(new BorderLayout());
            this.add((Component)jTabbedPane, "Center");
            this.add((Component)object, "South");
        }

        private void updateMenu() {
            OutputConfigDialog.this.blockActionsStart();
            ArrayList arrayList = OutputConfig.getConfigs((String)OutputConfigDialog.this.getDbID(), (int)this.type);
            arrayList.add(0, OutputConfig.getDefaultObject((int)this.type));
            if (!arrayList.contains(this.config)) {
                arrayList.add(0, this.config);
            }
            if (OutputConfigDialog.this.showNullObject && !this.config.isNull()) {
                arrayList.add(0, OutputConfig.getNullObject((int)this.type));
            }
            this.configMenu.removeAllItems();
            for (OutputConfig outputConfig : arrayList) {
                this.configMenu.addItem(outputConfig);
            }
            this.configMenu.setSelectedItem(this.config);
            this.updateConfig();
            OutputConfigDialog.this.blockActionsEnd();
        }

        private void updateConfig() {
            if (this.config.isNull()) {
                for (FlagPanel flagPanel : this.flagPanels) {
                    flagPanel.setFlag(0);
                }
                for (FlagPanel flagPanel : this.enablingFlagPanels) {
                    flagPanel.setEnabled(false);
                }
                this.deleteButton.setEnabled(false);
                this.nameField.setText("");
                AppController.setComponentEnabled(this.nameField, false);
                this.saveButton.setEnabled(false);
                return;
            }
            for (FlagPanel flagPanel : this.flagPanels) {
                flagPanel.setFlag(this.config.flags[flagPanel.flagIndex]);
            }
            for (FlagPanel flagPanel : this.enablingFlagPanels) {
                flagPanel.setEnabled(true);
            }
            if (!this.config.isUnsaved()) {
                this.deleteButton.setEnabled(true);
                this.nameField.setText(this.config.name);
            } else {
                this.deleteButton.setEnabled(false);
                this.nameField.setText("");
            }
            AppController.setComponentEnabled(this.nameField, true);
            this.saveButton.setEnabled(true);
        }

        private void doSave() {
            if (!this.validateInput()) {
                return;
            }
            String string = this.nameField.getText().trim();
            if (string.equalsIgnoreCase("(custom)") || string.equalsIgnoreCase("(not set)")) {
                this.nameField.setText("");
                string = "";
            }
            if (0 == string.length()) {
                OutputConfigDialog.this.errorReporter.reportWarning("Please provide a valid name for the saved settings");
                return;
            }
            this.config.name = string;
            if (!this.config.save(OutputConfigDialog.this.getDbID(), (ErrorLogger)OutputConfigDialog.this.errorReporter)) {
                this.config.name = "(custom)";
                this.nameField.setText("");
            }
            this.updateMenu();
        }

        private void doDelete() {
            if (this.config.isUnsaved() || this.config.isNull()) {
                return;
            }
            if (OutputConfig.deleteConfig((String)OutputConfigDialog.this.getDbID(), (int)this.config.type, (String)this.config.name)) {
                this.config.name = "(custom)";
            }
            this.updateMenu();
        }

        public boolean validateInput() {
            if (this.config.isNull()) {
                return true;
            }
            OutputConfig outputConfig = new OutputConfig(this.type, "");
            for (FlagPanel flagPanel : this.flagPanels) {
                outputConfig.flags[((FlagPanel)flagPanel).flagIndex] = flagPanel.getFlag();
            }
            if (!outputConfig.matchesConfig(this.config)) {
                this.config = outputConfig;
            }
            return true;
        }

        private class FlagPanel
        extends JPanel {
            private int flagIndex;
            private JCheckBox checkBox;
            private JComboBox<String> menu;
            private ArrayList<FlagPanel> enablesFlags;
            private boolean isImageFlag;
            private boolean isColorMapFlag;

            private FlagPanel(int n, String[] stringArray) {
                this.flagIndex = n;
                this.isImageFlag = 2 == ConfigPanel.this.type && 13 == this.flagIndex;
                this.isColorMapFlag = 2 == ConfigPanel.this.type && 15 == this.flagIndex;
                this.setLayout(new FlowLayout(0));
                if (this.isColorMapFlag) {
                    this.add(Box.createHorizontalStrut(30));
                    OutputConfigDialog.this.colorMapLabel.setText(stringArray[0]);
                    this.add(OutputConfigDialog.this.colorMapLabel);
                    this.add(OutputConfigDialog.this.colorMapMenu);
                    return;
                }
                this.checkBox = new JCheckBox(stringArray[0]);
                this.checkBox.setFocusable(false);
                this.checkBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = FlagPanel.this.checkBox.isSelected();
                        if (null != FlagPanel.this.menu) {
                            AppController.setComponentEnabled(FlagPanel.this.menu, bl);
                            if (FlagPanel.this.isImageFlag) {
                                AppController.setComponentEnabled(OutputConfigDialog.this.colorMapLabel, bl);
                                AppController.setComponentEnabled(OutputConfigDialog.this.colorMapMenu, bl);
                            }
                        }
                        if (null != FlagPanel.this.enablesFlags) {
                            for (FlagPanel flagPanel : FlagPanel.this.enablesFlags) {
                                flagPanel.setEnabled(bl);
                            }
                        }
                    }
                });
                this.add(this.checkBox);
                if (stringArray.length > 1) {
                    this.menu = new JComboBox();
                    this.menu.setFocusable(false);
                    for (int i = 1; i < stringArray.length; ++i) {
                        this.menu.addItem(stringArray[i]);
                    }
                    AppController.setComponentEnabled(this.menu, false);
                    this.add(this.menu);
                }
            }

            private int getFlag() {
                if (this.isColorMapFlag) {
                    if (AppController.isComponentEnabled(OutputConfigDialog.this.colorMapMenu)) {
                        return OutputConfigDialog.this.colorMapMenu.getSelectedKey();
                    }
                    return 0;
                }
                if (this.checkBox.isSelected()) {
                    if (null != this.menu) {
                        return this.menu.getSelectedIndex() + 1;
                    }
                    return 1;
                }
                return 0;
            }

            private void setFlag(int n) {
                if (this.isColorMapFlag) {
                    OutputConfigDialog.this.colorMapKey = n;
                    if (OutputConfigDialog.this.colorMapMenu.containsKey(n)) {
                        OutputConfigDialog.this.colorMapMenu.setSelectedKey(n);
                    }
                    return;
                }
                if (n < 1) {
                    this.checkBox.setSelected(false);
                    if (null != this.menu) {
                        AppController.setComponentEnabled(this.menu, false);
                    }
                    if (this.isImageFlag) {
                        AppController.setComponentEnabled(OutputConfigDialog.this.colorMapLabel, false);
                        AppController.setComponentEnabled(OutputConfigDialog.this.colorMapMenu, false);
                    }
                } else {
                    this.checkBox.setSelected(true);
                    if (null != this.menu) {
                        AppController.setComponentEnabled(this.menu, true);
                        if (n <= this.menu.getItemCount()) {
                            this.menu.setSelectedIndex(n - 1);
                        } else {
                            this.menu.setSelectedIndex(0);
                        }
                    }
                    if (this.isImageFlag) {
                        AppController.setComponentEnabled(OutputConfigDialog.this.colorMapLabel, true);
                        AppController.setComponentEnabled(OutputConfigDialog.this.colorMapMenu, true);
                    }
                }
            }

            private void addEnablesFlag(FlagPanel flagPanel) {
                if (null == this.enablesFlags) {
                    this.enablesFlags = new ArrayList();
                }
                this.enablesFlags.add(flagPanel);
            }

            @Override
            public void setEnabled(boolean bl) {
                if (this.isColorMapFlag) {
                    return;
                }
                if (bl) {
                    AppController.setComponentEnabled(this.checkBox, true);
                    if (null != this.menu) {
                        AppController.setComponentEnabled(this.menu, this.checkBox.isSelected());
                    }
                    if (this.isImageFlag) {
                        AppController.setComponentEnabled(OutputConfigDialog.this.colorMapLabel, this.checkBox.isSelected());
                        AppController.setComponentEnabled(OutputConfigDialog.this.colorMapMenu, this.checkBox.isSelected());
                    }
                } else {
                    AppController.setComponentEnabled(this.checkBox, false);
                    if (null != this.menu) {
                        AppController.setComponentEnabled(this.menu, false);
                    }
                    if (this.isImageFlag) {
                        AppController.setComponentEnabled(OutputConfigDialog.this.colorMapLabel, false);
                        AppController.setComponentEnabled(OutputConfigDialog.this.colorMapMenu, false);
                    }
                }
                if (null != this.enablesFlags) {
                    if (bl) {
                        bl = this.checkBox.isSelected();
                    }
                    for (FlagPanel flagPanel : this.enablesFlags) {
                        flagPanel.setEnabled(bl);
                    }
                }
            }
        }
    }
}

