/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbListener;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbSearch;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.CoordinateCopyPastePanel;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.TextInputDialog;
import gov.fcc.tvstudy.gui.editor.CoordinatePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ExtDbSearchDialog
extends AppDialog
implements ExtDbListener {
    public static final String WINDOW_TITLE = "Add Stations";
    private int studyType;
    private KeyedRecordMenu searchRecordTypeMenu;
    private int searchRecordType;
    private Integer defaultExtDbKey;
    private KeyedRecordMenu extDbMenu;
    private JCheckBox baselineCheckBox;
    private KeyedRecordMenu searchTypeMenu;
    private JCheckBox disableMXCheckBox;
    private JCheckBox mxFacilityIDOnlyCheckBox;
    private JCheckBox preferOperatingCheckBox;
    private JCheckBox desiredOnlyCheckBox;
    private JCheckBox serviceSearchCheckBox;
    private ArrayList<Service> servicesTV;
    private ArrayList<JCheckBox> serviceCheckBoxesTV;
    private JPanel servicePanelTV;
    private ArrayList<Service> servicesFM;
    private ArrayList<JCheckBox> serviceCheckBoxesFM;
    private JPanel servicePanelFM;
    private JCheckBox countrySearchCheckBox;
    private ArrayList<Country> countries;
    private ArrayList<JCheckBox> countryCheckBoxes;
    private JCheckBox statusSearchCheckBox;
    private ArrayList<JCheckBox> statusCheckBoxes;
    private JCheckBox radiusSearchCheckBox;
    private CoordinatePanel latitudePanel;
    private CoordinatePanel longitudePanel;
    private CoordinateCopyPastePanel copyPastePanel;
    private JTextField radiusField;
    private JTextField minimumChannelField;
    private JTextField maximumChannelField;
    private JCheckBox includeSharingGuestsCheckBox;
    private JButton addSQLButton;
    private JButton applyButton;
    private JComboBox<ExtDbSearch> searchMenu;
    private JButton deleteButton;
    private JTextField nameField;
    private JCheckBox autoRunCheckBox;
    public ExtDb extDb;
    public boolean useBaseline;
    public ExtDbSearch search;

    public ExtDbSearchDialog(AppEditor appEditor, Integer n, int n2) {
        super(appEditor, null, WINDOW_TITLE, Dialog.ModalityType.MODELESS);
        JCheckBox jCheckBox;
        Object object4;
        this.studyType = n2;
        this.defaultExtDbKey = n;
        this.search = new ExtDbSearch(this.studyType);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExtDbSearchDialog.this.blockActions()) {
                    ExtDbSearchDialog.this.updateSearchUI();
                    ExtDbSearchDialog.this.blockActionsEnd();
                }
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExtDbSearchDialog.this.blockActions()) {
                    ExtDbSearchDialog.this.updateControls();
                    ExtDbSearchDialog.this.blockActionsEnd();
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Search Record Type"));
        ArrayList arrayList = Source.getRecordTypes((int)n2);
        if (1 == arrayList.size()) {
            object4 = (KeyedRecord)arrayList.get(0);
            this.searchRecordType = ((KeyedRecord)object4).key;
            jPanel.add(Box.createHorizontalStrut(20));
            jPanel.add(new JLabel(((KeyedRecord)object4).name));
            jPanel.add(Box.createHorizontalStrut(20));
        } else {
            this.searchRecordTypeMenu = new KeyedRecordMenu(arrayList);
            this.searchRecordTypeMenu.addActionListener(actionListener);
            this.searchRecordType = this.searchRecordTypeMenu.getSelectedKey();
            jPanel.add(this.searchRecordTypeMenu);
        }
        this.baselineCheckBox = new JCheckBox("Baseline");
        this.baselineCheckBox.setFocusable(false);
        this.baselineCheckBox.addActionListener(actionListener2);
        jPanel.add(this.baselineCheckBox);
        arrayList.clear();
        this.extDbMenu = new KeyedRecordMenu(arrayList);
        this.extDbMenu.addActionListener(actionListener);
        this.extDbMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXy"));
        object4 = new JPanel();
        ((JComponent)object4).setBorder(BorderFactory.createTitledBorder("Search Station Data"));
        ((Container)object4).add(this.extDbMenu);
        arrayList.add(new KeyedRecord(1, "Desired stations"));
        arrayList.add(new KeyedRecord(3, "Protected stations"));
        arrayList.add(new KeyedRecord(2, "Undesired stations"));
        this.searchTypeMenu = new KeyedRecordMenu(arrayList);
        this.searchTypeMenu.addActionListener(actionListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Search Type"));
        jPanel2.add(this.searchTypeMenu);
        this.disableMXCheckBox = new JCheckBox("Disable all MX checks");
        this.disableMXCheckBox.setFocusable(false);
        this.disableMXCheckBox.addActionListener(actionListener);
        this.mxFacilityIDOnlyCheckBox = new JCheckBox("Use only facility ID for MX check");
        this.mxFacilityIDOnlyCheckBox.setFocusable(false);
        this.mxFacilityIDOnlyCheckBox.addActionListener(actionListener);
        this.preferOperatingCheckBox = new JCheckBox("Prefer operating facilities");
        this.preferOperatingCheckBox.setFocusable(false);
        this.desiredOnlyCheckBox = new JCheckBox("Add stations as desired-only");
        this.desiredOnlyCheckBox.setFocusable(false);
        this.serviceSearchCheckBox = new JCheckBox("Search by service");
        this.serviceSearchCheckBox.setFocusable(false);
        this.serviceSearchCheckBox.addActionListener(actionListener2);
        ArrayList arrayList2 = Service.getAllServices();
        this.servicesTV = new ArrayList();
        this.serviceCheckBoxesTV = new ArrayList();
        this.servicesFM = new ArrayList();
        this.serviceCheckBoxesFM = new ArrayList();
        for (Service object32 : arrayList2) {
            jCheckBox = new JCheckBox(object32.name);
            jCheckBox.setFocusable(false);
            if (1 == object32.serviceType.recordType) {
                this.servicesTV.add(object32);
                this.serviceCheckBoxesTV.add(jCheckBox);
                continue;
            }
            if (3 != object32.serviceType.recordType) continue;
            this.servicesFM.add(object32);
            this.serviceCheckBoxesFM.add(jCheckBox);
        }
        this.servicePanelTV = new JPanel();
        this.servicePanelTV.setLayout(new BoxLayout(this.servicePanelTV, 1));
        for (JCheckBox jCheckBox2 : this.serviceCheckBoxesTV) {
            this.servicePanelTV.add(jCheckBox2);
        }
        this.servicePanelFM = new JPanel();
        this.servicePanelFM.setLayout(new BoxLayout(this.servicePanelFM, 1));
        for (JCheckBox jCheckBox3 : this.serviceCheckBoxesFM) {
            this.servicePanelFM.add(jCheckBox3);
        }
        this.servicePanelFM.setVisible(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel3.add(this.serviceSearchCheckBox);
        jPanel3.add(this.servicePanelTV);
        jPanel3.add(this.servicePanelFM);
        this.countrySearchCheckBox = new JCheckBox("Search by country");
        this.countrySearchCheckBox.setFocusable(false);
        this.countrySearchCheckBox.addActionListener(actionListener2);
        this.countries = Country.getAllCountries();
        this.countryCheckBoxes = new ArrayList();
        for (Country country : this.countries) {
            jCheckBox = new JCheckBox(country.name);
            jCheckBox.setFocusable(false);
            this.countryCheckBoxes.add(jCheckBox);
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.add(this.countrySearchCheckBox);
        for (JCheckBox jCheckBox4 : this.countryCheckBoxes) {
            jPanel4.add(jCheckBox4);
        }
        this.statusSearchCheckBox = new JCheckBox("Search by status");
        this.statusSearchCheckBox.setFocusable(false);
        this.statusSearchCheckBox.addActionListener(actionListener2);
        this.statusCheckBoxes = new ArrayList();
        for (KeyedRecord keyedRecord : ExtDbRecord.getStatusList()) {
            jCheckBox = new JCheckBox(keyedRecord.name);
            jCheckBox.setFocusable(false);
            this.statusCheckBoxes.add(jCheckBox);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(BorderFactory.createEtchedBorder());
        jPanel5.add(this.statusSearchCheckBox);
        for (JCheckBox jCheckBox5 : this.statusCheckBoxes) {
            jPanel5.add(jCheckBox5);
        }
        this.radiusSearchCheckBox = new JCheckBox("Search by center point and radius");
        this.radiusSearchCheckBox.setFocusable(false);
        this.radiusSearchCheckBox.addActionListener(actionListener2);
        this.latitudePanel = new CoordinatePanel(this, this.search.center, false, null);
        this.longitudePanel = new CoordinatePanel(this, this.search.center, true, null);
        this.copyPastePanel = new CoordinateCopyPastePanel(this.latitudePanel, this.longitudePanel);
        this.radiusField = new JTextField(7);
        AppController.fixKeyBindings(this.radiusField);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Radius, km"));
        jPanel6.add(this.radiusField);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        jPanel8.add(this.radiusSearchCheckBox);
        jPanel7.add(jPanel8);
        jPanel8 = new JPanel(new FlowLayout(0));
        jPanel8.add(this.latitudePanel);
        jPanel8.add(this.copyPastePanel);
        jPanel7.add(jPanel8);
        jPanel8 = new JPanel(new FlowLayout(0));
        jPanel8.add(this.longitudePanel);
        jPanel7.add(jPanel8);
        jPanel8 = new JPanel(new FlowLayout(0));
        jPanel8.add(jPanel6);
        jPanel7.add(jPanel8);
        this.minimumChannelField = new JTextField(6);
        AppController.fixKeyBindings(this.minimumChannelField);
        this.maximumChannelField = new JTextField(6);
        AppController.fixKeyBindings(this.maximumChannelField);
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createTitledBorder("Min. Channel"));
        jPanel9.add(this.minimumChannelField);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createTitledBorder("Max. Channel"));
        jPanel10.add(this.maximumChannelField);
        JPanel jPanel11 = new JPanel();
        jPanel11.add(jPanel9);
        jPanel11.add(jPanel10);
        this.includeSharingGuestsCheckBox = new JCheckBox("Include sharing guests");
        this.includeSharingGuestsCheckBox.setFocusable(false);
        JPanel jPanel12 = new JPanel();
        jPanel12.add(this.includeSharingGuestsCheckBox);
        this.addSQLButton = new JButton("Add SQL");
        this.addSQLButton.setFocusable(false);
        this.addSQLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbSearchDialog.this.doAddSQL();
            }
        });
        this.searchMenu = new JComboBox();
        this.searchMenu.setFocusable(false);
        ExtDbSearch extDbSearch = new ExtDbSearch(0);
        extDbSearch.name = "XyXyXyXyXyXyXyXyXyXyXyXyXyXyXy";
        this.searchMenu.setPrototypeDisplayValue(extDbSearch);
        this.searchMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExtDbSearchDialog.this.blockActions()) {
                    ExtDbSearch extDbSearch = (ExtDbSearch)ExtDbSearchDialog.this.searchMenu.getSelectedItem();
                    if (null != extDbSearch && extDbSearch.name.length() > 0) {
                        ExtDbSearchDialog.this.setSearch(extDbSearch);
                        ExtDbSearchDialog.this.deleteButton.setEnabled(true);
                    } else {
                        ExtDbSearchDialog.this.deleteButton.setEnabled(false);
                    }
                    ExtDbSearchDialog.this.blockActionsEnd();
                }
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setFocusable(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbSearchDialog.this.doDelete();
            }
        });
        this.nameField = new JTextField(20);
        AppController.fixKeyBindings(this.nameField);
        this.autoRunCheckBox = new JCheckBox("Auto-run");
        this.autoRunCheckBox.setFocusable(false);
        JButton jButton = new JButton("Save");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbSearchDialog.this.doSave();
            }
        });
        JButton jButton2 = new JButton("Clear");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbSearchDialog.this.doClear();
            }
        });
        JButton jButton3 = new JButton("Close");
        jButton3.setFocusable(false);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbSearchDialog.this.cancel();
            }
        });
        this.applyButton = new JButton("Add");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtDbSearchDialog.this.doApply();
            }
        });
        JPanel jPanel13 = new JPanel();
        jPanel13.add((Component)object4);
        JPanel jPanel14 = new JPanel();
        jPanel14.add(jPanel2);
        Box box = Box.createVerticalBox();
        box.add(this.disableMXCheckBox);
        box.add(this.mxFacilityIDOnlyCheckBox);
        box.add(this.preferOperatingCheckBox);
        box.add(this.desiredOnlyCheckBox);
        JPanel jPanel15 = new JPanel();
        jPanel15.add(box);
        JPanel jPanel16 = new JPanel();
        jPanel16.add(jPanel3);
        JPanel jPanel17 = new JPanel();
        jPanel17.add(jPanel);
        Box box2 = Box.createVerticalBox();
        box2.add(jPanel17);
        box2.add(jPanel13);
        box2.add(jPanel14);
        box2.add(jPanel15);
        box2.add(jPanel16);
        JPanel jPanel18 = new JPanel();
        jPanel18.add(jPanel4);
        jPanel18.add(jPanel5);
        JPanel jPanel19 = new JPanel();
        jPanel19.add(jPanel7);
        JPanel jPanel20 = new JPanel(new FlowLayout(0));
        jPanel20.add(this.addSQLButton);
        JPanel jPanel21 = new JPanel(new FlowLayout(2));
        jPanel21.add(jButton2);
        Box box3 = Box.createHorizontalBox();
        box3.add(jPanel20);
        box3.add(jPanel21);
        Box box4 = Box.createVerticalBox();
        box4.add(jPanel18);
        box4.add(jPanel19);
        box4.add(jPanel11);
        box4.add(jPanel12);
        box4.add(box3);
        Box box5 = Box.createHorizontalBox();
        box5.add(box2);
        box5.add(box4);
        JPanel jPanel22 = new JPanel(new FlowLayout(0));
        jPanel22.add(this.searchMenu);
        jPanel22.add(this.deleteButton);
        JPanel jPanel23 = new JPanel(new FlowLayout(0));
        jPanel23.add(this.nameField);
        jPanel23.add(this.autoRunCheckBox);
        jPanel23.add(jButton);
        Box box6 = Box.createVerticalBox();
        box6.add(jPanel22);
        box6.add(jPanel23);
        JPanel jPanel24 = new JPanel(new BorderLayout());
        jPanel24.add((Component)box5, "Center");
        jPanel24.add((Component)box6, "South");
        JPanel jPanel25 = new JPanel(new FlowLayout(2));
        jPanel25.add(jButton3);
        jPanel25.add(this.applyButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel24, "Center");
        container.add((Component)jPanel25, "South");
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.width = 760;
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setResizable(true);
        this.setLocationSaved(true);
        this.updateDocumentName();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    public void updateExtDbList() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExtDbSearchDialog.this.doExtDbUpdate(false);
            }
        });
    }

    private void doExtDbUpdate(boolean bl) {
        ArrayList arrayList;
        ErrorReporter errorReporter = null;
        if (bl) {
            errorReporter = this.errorReporter;
            this.errorReporter.setTitle("Load Station Data List");
        }
        if (null == (arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)this.searchRecordType, (ErrorLogger)errorReporter))) {
            if (bl) {
                this.cancel();
            } else {
                return;
            }
        }
        this.blockActionsStart();
        int n = 0;
        if (bl) {
            if (null != this.defaultExtDbKey) {
                n = this.defaultExtDbKey;
            }
        } else {
            n = this.extDbMenu.getSelectedKey();
        }
        this.extDbMenu.removeAllItems();
        this.extDbMenu.addAllItems(arrayList);
        if (this.extDbMenu.containsKey(n)) {
            this.extDbMenu.setSelectedKey(n);
        }
        this.updateSearchUI();
        this.blockActionsEnd();
        if (bl) {
            this.updateMenu();
            if (arrayList.isEmpty()) {
                this.errorReporter.reportError("No station data found, please use Station Data Manager to add data");
            }
        }
    }

    public void setSearch(ExtDbSearch extDbSearch) {
        JCheckBox jCheckBox;
        Service service;
        int n;
        if (extDbSearch.studyType != this.studyType) {
            return;
        }
        this.blockActionsStart();
        if (null != this.searchRecordTypeMenu && this.searchRecordTypeMenu.containsKey(extDbSearch.recordType)) {
            this.searchRecordTypeMenu.setSelectedKey(extDbSearch.recordType);
        }
        if (this.searchTypeMenu.containsKey(extDbSearch.searchType)) {
            this.searchTypeMenu.setSelectedKey(extDbSearch.searchType);
        } else {
            this.searchTypeMenu.setSelectedKey(1);
        }
        this.disableMXCheckBox.setSelected(extDbSearch.disableMX);
        this.mxFacilityIDOnlyCheckBox.setSelected(extDbSearch.mxFacilityIDOnly);
        this.preferOperatingCheckBox.setSelected(extDbSearch.preferOperating);
        this.desiredOnlyCheckBox.setSelected(extDbSearch.desiredOnly);
        boolean bl = false;
        if (!extDbSearch.serviceKeys.isEmpty()) {
            for (n = 0; n < this.servicesTV.size(); ++n) {
                service = this.servicesTV.get(n);
                jCheckBox = this.serviceCheckBoxesTV.get(n);
                if (extDbSearch.serviceKeys.contains(service.key)) {
                    jCheckBox.setSelected(true);
                    bl = true;
                    continue;
                }
                jCheckBox.setSelected(false);
            }
            for (n = 0; n < this.servicesFM.size(); ++n) {
                service = this.servicesFM.get(n);
                jCheckBox = this.serviceCheckBoxesFM.get(n);
                if (extDbSearch.serviceKeys.contains(service.key)) {
                    jCheckBox.setSelected(true);
                    bl = true;
                    continue;
                }
                jCheckBox.setSelected(false);
            }
        }
        this.serviceSearchCheckBox.setSelected(bl);
        bl = false;
        if (!extDbSearch.countryKeys.isEmpty()) {
            for (n = 0; n < this.countries.size(); ++n) {
                service = this.countries.get(n);
                jCheckBox = this.countryCheckBoxes.get(n);
                if (extDbSearch.countryKeys.contains(service.key)) {
                    jCheckBox.setSelected(true);
                    bl = true;
                    continue;
                }
                jCheckBox.setSelected(false);
            }
        }
        this.countrySearchCheckBox.setSelected(bl);
        bl = false;
        if (!extDbSearch.statusTypes.isEmpty()) {
            int n2 = 0;
            for (KeyedRecord keyedRecord : ExtDbRecord.getStatusList()) {
                jCheckBox = this.statusCheckBoxes.get(n2++);
                if (extDbSearch.statusTypes.contains(keyedRecord.key)) {
                    jCheckBox.setSelected(true);
                    bl = true;
                    continue;
                }
                jCheckBox.setSelected(false);
            }
        }
        this.statusSearchCheckBox.setSelected(bl);
        bl = false;
        if (extDbSearch.radius > 0.0) {
            this.search.center.setLatLon(extDbSearch.center);
            this.radiusField.setText(AppCore.formatDistance((double)extDbSearch.radius));
            bl = true;
        } else {
            this.search.center.setLatLon(0.0, 0.0);
            this.radiusField.setText("");
        }
        this.latitudePanel.updatePanel();
        this.longitudePanel.updatePanel();
        this.radiusSearchCheckBox.setSelected(bl);
        if (0 == extDbSearch.minimumChannel) {
            this.minimumChannelField.setText("");
        } else {
            this.minimumChannelField.setText(String.valueOf(extDbSearch.minimumChannel));
        }
        if (0 == extDbSearch.maximumChannel) {
            this.maximumChannelField.setText("");
        } else {
            this.maximumChannelField.setText(String.valueOf(extDbSearch.maximumChannel));
        }
        this.includeSharingGuestsCheckBox.setSelected(extDbSearch.includeSharingGuests);
        this.search.additionalSQL = extDbSearch.additionalSQL.trim();
        if (0 == this.search.additionalSQL.length()) {
            this.addSQLButton.setText("Add SQL");
        } else {
            this.addSQLButton.setText("Edit SQL");
        }
        if (extDbSearch.name.equalsIgnoreCase("Desireds") || extDbSearch.name.equalsIgnoreCase("Undesireds") || extDbSearch.name.equalsIgnoreCase("Protecteds")) {
            this.nameField.setText("");
        } else {
            this.nameField.setText(extDbSearch.name);
        }
        this.autoRunCheckBox.setSelected(extDbSearch.autoRun);
        if (this.isVisible()) {
            this.updateSearchUI();
        }
        this.blockActionsEnd();
        if (this.isVisible()) {
            this.updateMenu();
        }
    }

    private void doClear() {
        this.blockActionsStart();
        this.disableMXCheckBox.setSelected(false);
        this.mxFacilityIDOnlyCheckBox.setSelected(false);
        this.preferOperatingCheckBox.setSelected(false);
        this.desiredOnlyCheckBox.setSelected(false);
        this.serviceSearchCheckBox.setSelected(false);
        for (JCheckBox jCheckBox : this.serviceCheckBoxesTV) {
            jCheckBox.setSelected(false);
        }
        for (JCheckBox jCheckBox : this.serviceCheckBoxesFM) {
            jCheckBox.setSelected(false);
        }
        this.countrySearchCheckBox.setSelected(false);
        for (JCheckBox jCheckBox : this.countryCheckBoxes) {
            jCheckBox.setSelected(false);
        }
        this.statusSearchCheckBox.setSelected(false);
        for (JCheckBox jCheckBox : this.statusCheckBoxes) {
            jCheckBox.setSelected(false);
        }
        this.radiusSearchCheckBox.setSelected(false);
        this.search.center.setLatLon(0.0, 0.0);
        this.latitudePanel.updatePanel();
        this.longitudePanel.updatePanel();
        this.radiusField.setText("");
        this.minimumChannelField.setText("");
        this.maximumChannelField.setText("");
        this.includeSharingGuestsCheckBox.setSelected(false);
        this.search.additionalSQL = "";
        this.addSQLButton.setText("Add SQL");
        this.updateSearchUI();
        this.blockActionsEnd();
        this.updateMenu();
    }

    private void updateSearchUI() {
        Object object;
        int n = this.extDbMenu.getSelectedKey();
        int n2 = this.searchRecordType;
        if (null != this.searchRecordTypeMenu && (n2 = this.searchRecordTypeMenu.getSelectedKey()) != this.searchRecordType) {
            this.searchRecordType = n2;
            object = ExtDb.getExtDbList((String)this.getDbID(), (int)this.searchRecordType);
            if (null != object) {
                this.extDbMenu.removeAllItems();
                this.extDbMenu.addAllItems((ArrayList<KeyedRecord>)object);
                if (this.extDbMenu.containsKey(n)) {
                    this.extDbMenu.setSelectedKey(n);
                } else {
                    n = this.extDbMenu.getSelectedKey();
                }
            }
        }
        object = null;
        if (n > 0) {
            object = ExtDb.getExtDb((String)this.getDbID(), (Integer)n, (boolean)true);
        }
        if (null != object && object.hasBaseline() && 1 == this.searchRecordType) {
            AppController.setComponentEnabled(this.baselineCheckBox, true);
        } else {
            this.baselineCheckBox.setSelected(false);
            AppController.setComponentEnabled(this.baselineCheckBox, false);
        }
        switch (this.searchRecordType) {
            default: {
                if (1 == this.studyType || 4 == this.studyType || 5 == this.studyType && 3 == this.searchRecordType) {
                    AppController.setComponentEnabled(this.searchTypeMenu, true);
                } else {
                    AppController.setComponentEnabled(this.searchTypeMenu, false);
                    this.searchTypeMenu.setSelectedKey(2);
                }
                if (2 == this.studyType) {
                    AppController.setComponentEnabled(this.disableMXCheckBox, false);
                    this.disableMXCheckBox.setSelected(true);
                } else {
                    AppController.setComponentEnabled(this.disableMXCheckBox, true);
                }
                if (this.disableMXCheckBox.isSelected()) {
                    AppController.setComponentEnabled(this.mxFacilityIDOnlyCheckBox, false);
                    this.mxFacilityIDOnlyCheckBox.setSelected(false);
                    AppController.setComponentEnabled(this.preferOperatingCheckBox, false);
                    this.preferOperatingCheckBox.setSelected(false);
                    AppController.setComponentEnabled(this.desiredOnlyCheckBox, false);
                    this.desiredOnlyCheckBox.setSelected(false);
                } else {
                    AppController.setComponentEnabled(this.mxFacilityIDOnlyCheckBox, true);
                    AppController.setComponentEnabled(this.preferOperatingCheckBox, true);
                    this.preferOperatingCheckBox.setSelected(true);
                    switch (this.searchTypeMenu.getSelectedKey()) {
                        default: {
                            AppController.setComponentEnabled(this.desiredOnlyCheckBox, true);
                            break;
                        }
                        case 3: {
                            AppController.setComponentEnabled(this.desiredOnlyCheckBox, true);
                            break;
                        }
                        case 2: {
                            AppController.setComponentEnabled(this.desiredOnlyCheckBox, false);
                            this.desiredOnlyCheckBox.setSelected(false);
                        }
                    }
                }
                if (3 == this.searchRecordType) {
                    this.servicePanelTV.setVisible(false);
                    this.servicePanelFM.setVisible(true);
                    this.includeSharingGuestsCheckBox.setSelected(false);
                    AppController.setComponentEnabled(this.includeSharingGuestsCheckBox, false);
                } else {
                    this.servicePanelFM.setVisible(false);
                    this.servicePanelTV.setVisible(true);
                    AppController.setComponentEnabled(this.includeSharingGuestsCheckBox, true);
                }
                AppController.setComponentEnabled(this.serviceSearchCheckBox, true);
                AppController.setComponentEnabled(this.countrySearchCheckBox, true);
                AppController.setComponentEnabled(this.statusSearchCheckBox, true);
                AppController.setComponentEnabled(this.radiusSearchCheckBox, true);
                break;
            }
            case 2: {
                AppController.setComponentEnabled(this.searchTypeMenu, false);
                this.searchTypeMenu.setSelectedKey(2);
                AppController.setComponentEnabled(this.disableMXCheckBox, false);
                this.disableMXCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.mxFacilityIDOnlyCheckBox, false);
                this.mxFacilityIDOnlyCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.preferOperatingCheckBox, false);
                this.preferOperatingCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.desiredOnlyCheckBox, false);
                this.desiredOnlyCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.serviceSearchCheckBox, false);
                this.serviceSearchCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.countrySearchCheckBox, false);
                this.countrySearchCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.statusSearchCheckBox, false);
                this.statusSearchCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.radiusSearchCheckBox, true);
                this.includeSharingGuestsCheckBox.setSelected(false);
                AppController.setComponentEnabled(this.includeSharingGuestsCheckBox, false);
            }
        }
        boolean bl = 2 != this.searchRecordType;
        AppController.setComponentEnabled(this.minimumChannelField, bl);
        AppController.setComponentEnabled(this.maximumChannelField, bl);
        this.updateControls();
    }

    private void updateControls() {
        boolean bl = this.serviceSearchCheckBox.isSelected();
        for (JCheckBox jCheckBox : this.serviceCheckBoxesTV) {
            AppController.setComponentEnabled(jCheckBox, bl);
        }
        for (JCheckBox jCheckBox : this.serviceCheckBoxesFM) {
            AppController.setComponentEnabled(jCheckBox, bl);
        }
        bl = this.countrySearchCheckBox.isSelected();
        for (JCheckBox jCheckBox : this.countryCheckBoxes) {
            AppController.setComponentEnabled(jCheckBox, bl);
        }
        if (this.baselineCheckBox.isSelected()) {
            AppController.setComponentEnabled(this.statusSearchCheckBox, false);
            bl = false;
        } else {
            AppController.setComponentEnabled(this.statusSearchCheckBox, true);
            bl = this.statusSearchCheckBox.isSelected();
        }
        for (JCheckBox jCheckBox : this.statusCheckBoxes) {
            AppController.setComponentEnabled(jCheckBox, bl);
        }
        bl = this.radiusSearchCheckBox.isSelected();
        this.latitudePanel.setEnabled(bl);
        this.longitudePanel.setEnabled(bl);
        this.copyPastePanel.setEnabled(bl);
        AppController.setComponentEnabled(this.radiusField, bl);
    }

    private void doAddSQL() {
        TextInputDialog textInputDialog = new TextInputDialog((AppEditor)this, "Add SQL", "Additional SQL for WHERE clause");
        textInputDialog.setInput(this.search.additionalSQL);
        AppController.showWindow(textInputDialog);
        if (textInputDialog.canceled) {
            return;
        }
        this.search.additionalSQL = textInputDialog.getInput();
        if (0 == this.search.additionalSQL.length()) {
            this.addSQLButton.setText("Add SQL");
        } else {
            this.addSQLButton.setText("Edit SQL");
        }
    }

    private void updateMenu() {
        this.blockActionsStart();
        ArrayList arrayList = ExtDbSearch.getSearches((String)this.getDbID(), (int)this.studyType);
        this.searchMenu.removeAllItems();
        ExtDbSearch extDbSearch = new ExtDbSearch(this.studyType);
        this.searchMenu.addItem(extDbSearch);
        String string = this.nameField.getText().trim();
        for (ExtDbSearch extDbSearch2 : arrayList) {
            this.searchMenu.addItem(extDbSearch2);
            if (!string.equals(extDbSearch2.name)) continue;
            extDbSearch = extDbSearch2;
        }
        this.searchMenu.setSelectedItem(extDbSearch);
        this.deleteButton.setEnabled(extDbSearch.name.length() > 0);
        this.blockActionsEnd();
    }

    private void doSave() {
        if (!this.validateInput(false)) {
            return;
        }
        String string = this.nameField.getText().trim();
        if (string.equalsIgnoreCase("Desireds") || string.equalsIgnoreCase("Undesireds") || string.equalsIgnoreCase("Protecteds")) {
            this.nameField.setText("");
            string = "";
        }
        if (0 == string.length()) {
            this.errorReporter.reportWarning("Please provide a valid name for the saved search");
            return;
        }
        this.search.name = string;
        this.search.autoRun = this.autoRunCheckBox.isSelected();
        if (!this.search.save(this.getDbID(), (ErrorLogger)this.errorReporter)) {
            this.search.name = "";
            this.nameField.setText("");
        }
        this.search.autoRun = false;
        this.updateMenu();
    }

    private void doDelete() {
        ExtDbSearch extDbSearch = (ExtDbSearch)this.searchMenu.getSelectedItem();
        if (null != extDbSearch && null != extDbSearch.name && extDbSearch.name.length() > 0) {
            ExtDbSearch.deleteSearch((String)this.getDbID(), (int)extDbSearch.studyType, (String)extDbSearch.name);
        }
        this.updateMenu();
    }

    private void doApply() {
        if (!this.validateInput(true)) {
            return;
        }
        this.parent.applyEditsFrom(this);
    }

    private boolean validateInput(boolean bl) {
        String string;
        if (!this.commitCurrentField()) {
            return false;
        }
        this.errorReporter.clearTitle();
        int n = this.extDbMenu.getSelectedKey();
        if (0 == n) {
            return false;
        }
        this.extDb = ExtDb.getExtDb((String)this.getDbID(), (Integer)n, (ErrorLogger)this.errorReporter);
        if (null == this.extDb) {
            return false;
        }
        this.search.recordType = this.searchRecordType;
        this.useBaseline = this.extDb.hasBaseline() && this.baselineCheckBox.isSelected();
        this.search.searchType = this.searchTypeMenu.getSelectedKey();
        this.search.disableMX = this.disableMXCheckBox.isSelected();
        this.search.mxFacilityIDOnly = this.mxFacilityIDOnlyCheckBox.isSelected();
        this.search.preferOperating = this.preferOperatingCheckBox.isSelected();
        this.search.desiredOnly = this.desiredOnlyCheckBox.isSelected();
        if (this.radiusSearchCheckBox.isSelected()) {
            string = this.radiusField.getText().trim();
            if (string.length() > 0) {
                try {
                    double d = Double.parseDouble(string);
                    if (d < 1.0 || d > 1000.0) {
                        this.errorReporter.reportValidationError("The radius value must be in the range 1 to 1000");
                        return false;
                    }
                    this.search.radius = d;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorReporter.reportValidationError("The radius value must be a number");
                    return false;
                }
            }
        } else {
            this.search.radius = 0.0;
        }
        if (2 == this.searchRecordType) {
            this.search.minimumChannel = 0;
            this.search.maximumChannel = 0;
        } else {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (3 == this.searchRecordType) {
                n3 = 200;
                n4 = 300;
            } else {
                n3 = 2;
                n4 = 69;
            }
            string = this.minimumChannelField.getText().trim();
            if (string.length() > 0) {
                try {
                    n2 = Integer.parseInt(string);
                    if (n2 < n3) {
                        this.errorReporter.reportValidationError("The minimum channel must be greater than or equal to " + n3);
                        return false;
                    }
                    this.search.minimumChannel = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorReporter.reportValidationError("The minimum channel must be a number");
                    return false;
                }
            } else {
                this.search.minimumChannel = 0;
            }
            string = this.maximumChannelField.getText().trim();
            if (string.length() > 0) {
                try {
                    n2 = Integer.parseInt(string);
                    if (n2 > n4) {
                        this.errorReporter.reportValidationError("The maximum channel must be less than or equal to " + n4);
                        return false;
                    }
                    this.search.maximumChannel = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorReporter.reportValidationError("The maximum channel must be a number");
                    return false;
                }
            } else {
                this.search.maximumChannel = 0;
            }
            if (this.search.minimumChannel > 0 && this.search.maximumChannel > 0 && this.search.minimumChannel > this.search.maximumChannel) {
                this.errorReporter.reportValidationError("The minimum channel must be less than or equal to the maximum channel");
                return false;
            }
        }
        this.search.includeSharingGuests = this.includeSharingGuestsCheckBox.isSelected();
        boolean bl2 = true;
        this.search.serviceKeys.clear();
        if (this.serviceSearchCheckBox.isSelected()) {
            ArrayList<Service> arrayList = this.servicesTV;
            ArrayList<JCheckBox> arrayList2 = this.serviceCheckBoxesTV;
            if (3 == this.searchRecordType) {
                arrayList = this.servicesFM;
                arrayList2 = this.serviceCheckBoxesFM;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Service service = arrayList.get(i);
                JCheckBox jCheckBox = arrayList2.get(i);
                if (!jCheckBox.isSelected()) continue;
                this.search.serviceKeys.add(service.key);
                bl2 = false;
            }
            if (bl2) {
                this.errorReporter.reportWarning("Please select at least one service");
                return false;
            }
        }
        this.search.countryKeys.clear();
        if (this.countrySearchCheckBox.isSelected()) {
            for (int i = 0; i < this.countries.size(); ++i) {
                Country country = this.countries.get(i);
                JCheckBox jCheckBox = this.countryCheckBoxes.get(i);
                if (!jCheckBox.isSelected()) continue;
                this.search.countryKeys.add(country.key);
                bl2 = false;
            }
            if (bl2) {
                this.errorReporter.reportWarning("Please select at least one country");
                return false;
            }
        }
        this.search.statusTypes.clear();
        if (this.statusSearchCheckBox.isSelected() && !this.useBaseline) {
            int n5 = 0;
            for (JCheckBox jCheckBox : ExtDbRecord.getStatusList()) {
                JCheckBox jCheckBox2;
                if (!(jCheckBox2 = this.statusCheckBoxes.get(n5++)).isSelected()) continue;
                this.search.statusTypes.add(((KeyedRecord)jCheckBox).key);
                bl2 = false;
            }
            if (bl2) {
                this.errorReporter.reportWarning("Please select at least one status");
                return false;
            }
        }
        if (this.radiusSearchCheckBox.isSelected()) {
            if (0.0 == this.search.center.latitude || 0.0 == this.search.center.longitude || 0.0 == this.search.radius) {
                this.errorReporter.reportWarning("Please enter search radius and center coordinates");
                return false;
            }
            bl2 = false;
        }
        if (this.search.minimumChannel > 0 || this.search.maximumChannel > 0) {
            bl2 = false;
        }
        if (this.search.additionalSQL.length() > 0) {
            bl2 = false;
        }
        if (bl2 && bl && 1 == this.search.searchType) {
            AppController.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "<HTML>No search criteria are selected.  This will<BR>match <B>all records</B> in the data set.<BR><BR>Are you sure you want to continue?</HTML>", "Confirm Big Search", 0, 2)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void windowWillOpen() {
        this.setLocationRelativeTo(this.getOwner());
        this.blockActionsClear();
        ExtDb.addListener((ExtDbListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExtDbSearchDialog.this.doExtDbUpdate(true);
            }
        });
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        ExtDb.removeListener((ExtDbListener)this);
        this.blockActionsSet();
        this.parent.editorClosing(this);
    }
}

