/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.RootEditor;
import java.awt.Component;
import java.awt.Window;
import java.io.PrintStream;

public class ErrorReporter
extends ErrorLogger {
    private RootEditor rootEditor;
    private Window parent;
    private String defaultTitle;
    private String title;

    public ErrorReporter(RootEditor rootEditor, Window window, String string) {
        super((StringBuilder)null);
        this.rootEditor = rootEditor;
        this.parent = window;
        this.title = this.defaultTitle = string;
    }

    public ErrorReporter(Window window, String string) {
        super((StringBuilder)null);
        this.parent = window;
        this.title = this.defaultTitle = string;
    }

    public ErrorReporter(RootEditor rootEditor, Window window, String string, PrintStream printStream, StringBuilder stringBuilder) {
        super(printStream, stringBuilder);
        this.rootEditor = rootEditor;
        this.parent = window;
        this.title = this.defaultTitle = string;
    }

    public Window getWindow() {
        return this.parent;
    }

    public void setTitle(String string) {
        if (null != this.defaultTitle) {
            this.title = string;
        }
    }

    public void clearTitle() {
        this.title = this.defaultTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public void reportValidationError(String string) {
        this.reportValidationError(this.title, string);
    }

    public void reportValidationError(String string, String string2) {
        if (null == this.title) {
            string = null;
        }
        if (null != this.rootEditor) {
            this.rootEditor.reportValidationError(this.parent, string, string2, 2);
        } else if (null != string) {
            ErrorReporter.doShowMessage(this.parent, string2, string, 2);
        }
        this.doReportError(string2, 2);
    }

    public void reportError(String string, int n) {
        this.reportError(this.title, string, n);
    }

    public void reportError(String string) {
        this.reportError(this.title, string, 3);
    }

    public void reportError(String string, String string2) {
        this.reportError(string, string2, 3);
    }

    public void reportWarning(String string) {
        this.reportError(this.title, string, 2);
    }

    public void reportWarning(String string, String string2) {
        this.reportError(string, string2, 2);
    }

    public void reportMessage(String string) {
        this.reportError(this.title, string, 1);
    }

    public void reportMessage(String string, String string2) {
        this.reportError(string, string2, 1);
    }

    public void reportError(String string, String string2, int n) {
        if (null != this.title && null != string) {
            ErrorReporter.doShowMessage(this.parent, string2, string, n);
        }
        this.doReportError(string2, n);
    }

    public void showMessages() {
        this.showMessages(this.title);
    }

    public void showMessages(String string) {
        if (null != this.messageLog && null != this.title && null != string) {
            String string2 = this.messageLog.toString();
            ErrorReporter.doShowMessage(this.parent, string2, string, 1);
        }
    }

    private static void doShowMessage(Component component, String string, String string2, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if ('\n' == string.charAt(i)) {
                ++n2;
                if (n3 > n4) {
                    n4 = n3;
                }
                n3 = 0;
                continue;
            }
            ++n3;
        }
        if (n3 > 0) {
            ++n2;
            if (n3 > n4) {
                n4 = n3;
            }
        }
        if (n4 > 120 || n2 > 10) {
            AppController.showLongMessage(component, string, string2, n);
        } else {
            AppController.showMessage(component, string, string2, n);
        }
    }
}

