/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.gui.AppController;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class EditMenu
extends JMenu {
    private KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, AppController.MENU_SHORTCUT_KEY_MASK);
    private KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, AppController.MENU_SHORTCUT_KEY_MASK);
    private KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, AppController.MENU_SHORTCUT_KEY_MASK);
    private KeyStroke selectAllKeyStroke = KeyStroke.getKeyStroke(65, AppController.MENU_SHORTCUT_KEY_MASK);
    private JTable targetTable;
    private JMenuItem tableCopyMenuItem;
    private JMenuItem tableSelectAllMenuItem;

    public EditMenu() {
        super("Edit");
        JMenuItem jMenuItem = new JMenuItem("Cut");
        jMenuItem.setAccelerator(this.cutKeyStroke);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(actionEvent, EditMenu.this.cutKeyStroke);
            }
        });
        this.add(jMenuItem);
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.setAccelerator(this.copyKeyStroke);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(actionEvent, EditMenu.this.copyKeyStroke);
            }
        });
        this.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.setAccelerator(this.pasteKeyStroke);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(actionEvent, EditMenu.this.pasteKeyStroke);
            }
        });
        this.add(jMenuItem);
        jMenuItem = new JMenuItem("Select All");
        jMenuItem.setAccelerator(this.selectAllKeyStroke);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(actionEvent, EditMenu.this.selectAllKeyStroke);
            }
        });
        this.add(jMenuItem);
        this.tableCopyMenuItem = new JMenuItem("Table Copy");
        this.tableCopyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(null, EditMenu.this.copyKeyStroke);
            }
        });
        this.tableSelectAllMenuItem = new JMenuItem("Table Select All");
        this.tableSelectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(null, EditMenu.this.selectAllKeyStroke);
            }
        });
    }

    public void setTargetTable(JTable jTable) {
        if (null == jTable) {
            if (null != this.targetTable) {
                this.remove(this.tableCopyMenuItem);
                this.remove(this.tableSelectAllMenuItem);
            }
        } else if (null == this.targetTable) {
            this.insert(this.tableCopyMenuItem, 4);
            this.insert(this.tableSelectAllMenuItem, 5);
        }
        this.targetTable = jTable;
    }

    private void runAction(ActionEvent actionEvent, KeyStroke keyStroke) {
        Object object;
        if (null != actionEvent) {
            Object object2;
            object = null;
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component instanceof JComponent && null != (object2 = ((JComponent)component).getInputMap().get(keyStroke)) && null != (object = (Object)((JComponent)component).getActionMap().get(object2))) {
                object.actionPerformed(actionEvent);
                return;
            }
        }
        if (null == this.targetTable) {
            AppController.beep();
            return;
        }
        if (keyStroke == this.cutKeyStroke || keyStroke == this.pasteKeyStroke) {
            AppController.beep();
            return;
        }
        if (keyStroke == this.copyKeyStroke) {
            object = this.targetTable.getSelectedRows();
            if (0 == ((int[])object).length) {
                AppController.beep();
                return;
            }
            int n = this.targetTable.getColumnCount();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < ((Object)object).length; ++i) {
                String string = "";
                for (int j = 0; j < n; ++j) {
                    Object object3 = this.targetTable.getValueAt((int)object[i], j);
                    String string2 = null == object3 ? "" : object3.toString();
                    if ((string2 = string2.replace('\"', '\'')).contains("\t")) {
                        string2 = "\"" + string2 + "\"";
                    }
                    stringBuilder.append(string + string2);
                    string = "\t";
                }
                stringBuilder.append("\n");
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            return;
        }
        if (keyStroke == this.selectAllKeyStroke) {
            this.targetTable.setRowSelectionInterval(0, this.targetTable.getRowCount() - 1);
            return;
        }
        AppController.beep();
    }
}

