/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppPanel;
import gov.fcc.tvstudy.gui.CalendarDialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class DateSelectionPanel
extends AppPanel {
    private static final ImageIcon setButtonIcon;
    private Date currentDate;
    private boolean allowNullDate;
    private boolean allowFutureDate;
    private Date lockoutDate;
    private Date lastDateSet;
    private JLabel dateLabel;
    private JLabel dayLabel;
    private JButton setButton;
    private DateSelectionPanel outerThis = this;

    public DateSelectionPanel(AppEditor appEditor, String string, boolean bl) {
        super(appEditor);
        this.makePanel(string, true, bl);
    }

    public DateSelectionPanel(AppEditor appEditor, String string, boolean bl, Runnable runnable) {
        super(appEditor, runnable);
        this.makePanel(string, true, bl);
    }

    public DateSelectionPanel(AppEditor appEditor, boolean bl, boolean bl2) {
        super(appEditor);
        this.makePanel(null, bl, bl2);
    }

    public DateSelectionPanel(AppEditor appEditor, boolean bl, boolean bl2, Runnable runnable) {
        super(appEditor, runnable);
        this.makePanel(null, bl, bl2);
    }

    private void makePanel(String string, boolean bl, boolean bl2) {
        this.allowNullDate = true;
        if (null != string && string.length() > 0) {
            this.setBorder(BorderFactory.createTitledBorder(string));
        } else if (bl) {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        this.dateLabel = new JLabel();
        this.dateLabel.setHorizontalAlignment(0);
        this.dateLabel.setAlignmentX(0.5f);
        Dimension dimension = AppController.labelSize[10];
        this.dateLabel.setPreferredSize(dimension);
        this.dateLabel.setMinimumSize(dimension);
        this.dateLabel.setMaximumSize(dimension);
        if (bl2) {
            this.dayLabel = new JLabel();
            this.dayLabel.setHorizontalAlignment(0);
            this.dayLabel.setAlignmentX(0.5f);
            this.dayLabel.setPreferredSize(dimension);
            this.dayLabel.setMinimumSize(dimension);
            this.dayLabel.setMaximumSize(dimension);
        }
        if (null != setButtonIcon) {
            this.setButton = new JButton(setButtonIcon);
            dimension = new Dimension(29, 29);
            this.setButton.setPreferredSize(dimension);
            this.setButton.setMinimumSize(dimension);
            this.setButton.setMaximumSize(dimension);
        } else {
            this.setButton = new JButton("Set");
        }
        this.setButton.setFocusable(false);
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarDialog calendarDialog = new CalendarDialog(DateSelectionPanel.this.parent);
                calendarDialog.setAllState(DateSelectionPanel.this.allowNullDate, DateSelectionPanel.this.allowFutureDate, DateSelectionPanel.this.lockoutDate, DateSelectionPanel.this.currentDate);
                calendarDialog.setLocationRelativeTo(DateSelectionPanel.this.outerThis);
                AppController.showWindow(calendarDialog);
                DateSelectionPanel.this.doSetDate(calendarDialog.getDate());
                if (!calendarDialog.canceled && null != DateSelectionPanel.this.callBack) {
                    DateSelectionPanel.this.callBack.run();
                }
            }
        });
        if (bl2) {
            Box box = Box.createVerticalBox();
            box.add(this.dateLabel);
            box.add(this.dayLabel);
            this.add(box);
        } else {
            this.add(this.dateLabel);
        }
        this.add(this.setButton);
        this.setAlignmentX(0.5f);
    }

    @Override
    public void setEnabled(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DateSelectionPanel.this.setButton.setEnabled(bl2);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.setButton.isEnabled();
    }

    @Override
    public void setToolTipText(String string) {
        this.setButton.setToolTipText(string);
    }

    public void setNullAllowed(boolean bl) {
        this.allowNullDate = bl;
        if (!this.allowNullDate && null == this.currentDate) {
            this.doSetDate(this.getToday());
        }
    }

    public boolean isNullAllowed() {
        return this.allowNullDate;
    }

    public void setFutureAllowed(boolean bl) {
        this.allowFutureDate = bl;
    }

    public boolean isFutureAllowed() {
        return this.allowFutureDate;
    }

    public void setLockoutDate(Date date) {
        this.lockoutDate = null != date ? this.getDay(date) : null;
    }

    public Date getLockoutDate() {
        return this.lockoutDate;
    }

    public void setText(String string) {
        Date date = null;
        if ((string = string.trim()).length() > 0) {
            date = AppCore.parseDate((String)string);
        }
        this.setDate(date);
    }

    public String getText() {
        return this.dateLabel.getText().trim();
    }

    public void setDate(Date date) {
        this.lastDateSet = date;
        if (null != date) {
            date = this.getDay(date);
        }
        this.doSetDate(date);
    }

    public void changeDate(Date date) {
        if (null != date) {
            date = this.getDay(date);
        }
        this.doSetDate(date);
    }

    private void doSetDate(Date date) {
        if (!this.allowNullDate && null == date) {
            date = this.getToday();
        }
        this.currentDate = date;
        if (null != this.currentDate) {
            this.dateLabel.setText(AppCore.formatDate((Date)this.currentDate));
            if (null != this.dayLabel) {
                this.dayLabel.setText(AppCore.formatDay((Date)this.currentDate));
            }
        } else {
            this.dateLabel.setText(" ");
            if (null != this.dayLabel) {
                this.dayLabel.setText(" ");
            }
        }
    }

    public Date getDate() {
        return this.currentDate;
    }

    public boolean isDateChanged() {
        if (null == this.lastDateSet) {
            return null != this.currentDate;
        }
        if (null == this.currentDate) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.lastDateSet);
        int n = calendar.get(6);
        int n2 = calendar.get(1);
        calendar.setTime(this.currentDate);
        return calendar.get(6) != n || calendar.get(1) != n2;
    }

    private Date getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date getToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    static {
        URL uRL = ClassLoader.getSystemResource("gov/fcc/tvstudy/gui/CalendarButtonIcon.png");
        setButtonIcon = null != uRL ? new ImageIcon(uRL) : null;
    }
}

