/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.gui.AppPanel;
import gov.fcc.tvstudy.gui.editor.CoordinatePanel;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;

public class CoordinateCopyPastePanel
extends AppPanel {
    private CoordinatePanel latitudePanel;
    private CoordinatePanel longitudePanel;
    private JButton pasteButton;

    public CoordinateCopyPastePanel(CoordinatePanel coordinatePanel, CoordinatePanel coordinatePanel2) {
        super(coordinatePanel.getOriginalParent());
        this.latitudePanel = coordinatePanel;
        this.longitudePanel = coordinatePanel2;
        JButton jButton = new JButton("Copy");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoordinateCopyPastePanel.this.doCopy();
            }
        });
        this.pasteButton = new JButton("Paste");
        this.pasteButton.setFocusable(false);
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoordinateCopyPastePanel.this.doPaste();
            }
        });
        Box box = Box.createVerticalBox();
        box.add(jButton);
        box.add(this.pasteButton);
        this.setLayout(new FlowLayout());
        this.add(box);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.pasteButton.setEnabled(bl);
    }

    private void doCopy() {
        StringSelection stringSelection = new StringSelection(String.format(Locale.US, "%.8f,%.8f", this.latitudePanel.getCoordinate(), this.longitudePanel.getCoordinate()));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    private void doPaste() {
        try {
            String string;
            String[] stringArray;
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (null != transferable && (stringArray = (string = (String)transferable.getTransferData(DataFlavor.stringFlavor)).split(",")).length >= 2) {
                double d = Double.parseDouble(stringArray[0]);
                double d2 = Double.parseDouble(stringArray[1]);
                this.latitudePanel.setCoordinate(d);
                this.longitudePanel.setCoordinate(d2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

