/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.EditMenu;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.RootEditor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public abstract class AppFrame
extends JFrame
implements AppEditor {
    protected AppEditor parent;
    protected ErrorReporter errorReporter;
    private int blockActionsCount;
    protected String documentName;
    protected String baseTitle;
    protected int titleKey;
    protected int shortcutKey;
    protected String keyTitle;
    protected String displayTitle;
    protected JMenu fileMenu;
    protected EditMenu editMenu;
    protected JMenu extraMenu;
    protected JMenu windowMenu;
    protected JMenu helpMenu;
    protected JMenuItem windowMenuItem;
    private boolean locationSaved;
    private boolean disposeOnClose;
    private JTextField currentField;

    public AppFrame(AppEditor appEditor, String string) {
        super(string);
        this.parent = appEditor;
        this.errorReporter = new ErrorReporter(this.getRootEditor(), this, string);
        this.blockActionsCount = -1;
        this.baseTitle = string;
        this.shortcutKey = -1;
        this.keyTitle = string;
        this.displayTitle = string;
        if (this.showsFileMenu()) {
            this.fileMenu = new JMenu(this.getFileMenuName());
        }
        if (this.showsEditMenu()) {
            this.editMenu = new EditMenu();
        }
        if (this.showsExtraMenu()) {
            this.extraMenu = new JMenu(this.getExtraMenuName());
        }
        this.windowMenu = new JMenu("Window");
        this.helpMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("About TVStudy");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(46, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppController.showAbout();
            }
        });
        this.helpMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Check Installation");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppController.checkInstall();
            }
        });
        this.helpMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Documentation");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(47, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppController.showHelp();
            }
        });
        this.helpMenu.add(jMenuItem3);
        this.helpMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Preferences");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(44, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppController.showPreferences();
            }
        });
        this.helpMenu.add(jMenuItem4);
        JMenuBar jMenuBar = new JMenuBar();
        if (null != this.fileMenu) {
            jMenuBar.add(this.fileMenu);
        }
        if (null != this.editMenu) {
            jMenuBar.add(this.editMenu);
        }
        if (null != this.extraMenu) {
            jMenuBar.add(this.extraMenu);
        }
        jMenuBar.add(this.windowMenu);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        this.locationSaved = true;
        this.disposeOnClose = true;
        this.setLocation(new Point(100, 40));
    }

    @Override
    public String getDbID() {
        return this.parent.getDbID();
    }

    @Override
    public RootEditor getRootEditor() {
        if (null == this.parent) {
            return null;
        }
        return this.parent.getRootEditor();
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    @Override
    public boolean blockActions() {
        if (this.blockActionsCount != 0) {
            return false;
        }
        this.blockActionsStart();
        return true;
    }

    @Override
    public void blockActionsStart() {
        if (this.blockActionsCount >= 0) {
            ++this.blockActionsCount;
        }
    }

    @Override
    public void blockActionsEnd() {
        if (this.blockActionsCount > 0) {
            --this.blockActionsCount;
        }
    }

    @Override
    public void blockActionsSet() {
        this.blockActionsCount = -1;
    }

    @Override
    public void blockActionsClear() {
        this.blockActionsCount = 0;
    }

    @Override
    public void setDocumentName(String string) {
        this.documentName = string;
        this.updateTitles();
    }

    @Override
    public String getDocumentName() {
        return this.documentName;
    }

    @Override
    public void updateDocumentName() {
    }

    @Override
    public void setCurrentField(JTextField jTextField) {
        this.currentField = jTextField;
    }

    @Override
    public JTextField getCurrentField() {
        return this.currentField;
    }

    @Override
    public boolean commitCurrentField() {
        if (null != this.currentField) {
            this.errorReporter.clearErrors();
            this.currentField.postActionEvent();
            return !this.errorReporter.hasErrors();
        }
        return true;
    }

    @Override
    public void setDidEdit() {
    }

    @Override
    public AppEditor getEditorFor(Object object) {
        return null;
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
    }

    public String getBaseTitle() {
        return this.baseTitle;
    }

    public String getKeyTitle() {
        return this.keyTitle;
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public String getTitle() {
        return this.displayTitle;
    }

    public void setTitleKey(int n) {
        this.titleKey = n;
        this.updateTitles();
    }

    public int getTitleKey() {
        return this.titleKey;
    }

    public void setShortcutKey(int n) {
        if (n < 0 || n > 9) {
            n = -1;
        }
        this.shortcutKey = n;
        this.updateTitles();
    }

    public int getShortcutKey() {
        return this.shortcutKey;
    }

    protected void updateTitles() {
        this.keyTitle = 0 == this.titleKey ? this.baseTitle : this.baseTitle + " " + this.titleKey;
        this.displayTitle = null == this.documentName || 0 == this.documentName.length() ? this.keyTitle : this.baseTitle + ": " + this.documentName;
        String string = this.displayTitle;
        if (this.shortcutKey >= 0) {
            string = 2 == AppController.MENU_SHORTCUT_KEY_MASK ? string + "  Ctrl-" + this.shortcutKey : string + "  \u2318" + this.shortcutKey;
        }
        super.setTitle(string);
        if (null != this.windowMenuItem) {
            this.windowMenuItem.setText(this.displayTitle);
        }
    }

    protected boolean showsFileMenu() {
        return true;
    }

    protected String getFileMenuName() {
        return "File";
    }

    protected boolean showsEditMenu() {
        return true;
    }

    protected boolean showsExtraMenu() {
        return false;
    }

    protected String getExtraMenuName() {
        return "Extra";
    }

    public JMenu getWindowMenu() {
        return this.windowMenu;
    }

    public void setWindowMenuItem(JMenuItem jMenuItem) {
        this.windowMenuItem = jMenuItem;
        if (null != jMenuItem) {
            jMenuItem.setText(this.displayTitle);
        }
    }

    public JMenuItem getWindowMenuItem() {
        return this.windowMenuItem;
    }

    public void setLocationSaved(boolean bl) {
        this.locationSaved = bl;
    }

    public boolean getLocationSaved() {
        return this.locationSaved;
    }

    public void setDisposeOnClose(boolean bl) {
        this.disposeOnClose = bl;
    }

    public boolean getDisposeOnClose() {
        return this.disposeOnClose;
    }

    public abstract void windowWillOpen();

    public boolean windowShouldClose() {
        return true;
    }

    public abstract void windowWillClose();

    public boolean closeIfPossible() {
        if (!this.isVisible()) {
            return true;
        }
        if (this.windowShouldClose()) {
            AppController.hideWindow(this);
            return true;
        }
        return false;
    }

    public boolean closeWithoutSave() {
        return false;
    }
}

