/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.RootEditor;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JTextField;

public abstract class AppDialog
extends JDialog
implements AppEditor {
    protected AppEditor parent;
    protected ErrorReporter errorReporter;
    private int blockActionsCount;
    protected String baseTitle;
    protected String documentName;
    protected String displayTitle;
    private boolean locationSaved;
    private boolean disposeOnClose;
    private JTextField currentField;

    public AppDialog(AppEditor appEditor, String string, Dialog.ModalityType modalityType) {
        super(appEditor.getWindow(), string, modalityType);
        this.doSetup(appEditor, string);
    }

    public AppDialog(AppEditor appEditor, Window window, String string, Dialog.ModalityType modalityType) {
        super(window, string, modalityType);
        this.doSetup(appEditor, string);
    }

    private void doSetup(AppEditor appEditor, String string) {
        this.parent = appEditor;
        this.errorReporter = new ErrorReporter(this.getRootEditor(), this, string);
        this.blockActionsCount = -1;
        this.baseTitle = string;
        this.displayTitle = string;
        this.locationSaved = false;
        this.disposeOnClose = true;
        this.setResizable(false);
        this.setLocation(new Point(120, 60));
    }

    @Override
    public String getDbID() {
        return this.parent.getDbID();
    }

    @Override
    public RootEditor getRootEditor() {
        return this.parent.getRootEditor();
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    @Override
    public boolean blockActions() {
        if (this.blockActionsCount != 0) {
            return false;
        }
        this.blockActionsStart();
        return true;
    }

    @Override
    public void blockActionsStart() {
        if (this.blockActionsCount >= 0) {
            ++this.blockActionsCount;
        }
    }

    @Override
    public void blockActionsEnd() {
        if (this.blockActionsCount > 0) {
            --this.blockActionsCount;
        }
    }

    @Override
    public void blockActionsSet() {
        this.blockActionsCount = -1;
    }

    @Override
    public void blockActionsClear() {
        this.blockActionsCount = 0;
    }

    @Override
    public void setDocumentName(String string) {
        this.documentName = string;
        this.updateTitles();
    }

    @Override
    public String getDocumentName() {
        return this.documentName;
    }

    @Override
    public void updateDocumentName() {
    }

    @Override
    public void setCurrentField(JTextField jTextField) {
        this.currentField = jTextField;
    }

    @Override
    public JTextField getCurrentField() {
        return this.currentField;
    }

    @Override
    public boolean commitCurrentField() {
        if (null != this.currentField) {
            this.errorReporter.clearErrors();
            this.currentField.postActionEvent();
            return !this.errorReporter.hasErrors();
        }
        return true;
    }

    @Override
    public void setDidEdit() {
    }

    @Override
    public AppEditor getEditorFor(Object object) {
        return null;
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
    }

    public String getBaseTitle() {
        return this.baseTitle;
    }

    public String getKeyTitle() {
        return this.baseTitle;
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public String getTitle() {
        return this.displayTitle;
    }

    protected void updateTitles() {
        this.displayTitle = null == this.documentName || 0 == this.documentName.length() ? this.baseTitle : this.baseTitle + ": " + this.documentName;
        super.setTitle(this.displayTitle);
    }

    public void setLocationSaved(boolean bl) {
        this.locationSaved = bl;
    }

    public boolean getLocationSaved() {
        return this.locationSaved;
    }

    public void setDisposeOnClose(boolean bl) {
        this.disposeOnClose = bl;
    }

    public boolean getDisposeOnClose() {
        return this.disposeOnClose;
    }

    public abstract void windowWillOpen();

    public boolean windowShouldClose() {
        return true;
    }

    public abstract void windowWillClose();

    public boolean cancel() {
        AppController.hideWindow(this);
        return true;
    }
}

