/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppFrame;
import gov.fcc.tvstudy.gui.DbController;
import gov.fcc.tvstudy.gui.EditMenu;
import gov.fcc.tvstudy.gui.RootEditor;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.run.RunManager;
import gov.fcc.tvstudy.gui.run.RunPanelProcess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.JTextComponent;

public class AppController
implements WindowListener {
    public static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final Color DISABLED_TEXT_BACKGROUND = new Color(233, 233, 233);
    public static final int SIZE_MAX_COLUMNS = 80;
    public static final int[] textFieldWidth = new int[81];
    public static final Dimension[] labelSize = new Dimension[81];
    public static boolean ShowUtilityUI;
    public static boolean ShowMacOSPrefs;
    private static AppController controller;
    private static Window currentWindow;
    private static ArrayList<AppFrame> windowList;
    private static boolean[] shortcutKeyInUse;
    private static boolean isClosing;
    private static int[] maps;
    private static KeyStroke[] keys;
    private static PrefsDialog prefsDialog;

    public static void showWindow(Window window) {
        if (window.isVisible()) {
            return;
        }
        window.addWindowListener(controller);
        if (window instanceof JFrame) {
            ((JFrame)window).setDefaultCloseOperation(0);
        } else if (window instanceof JDialog) {
            ((JDialog)window).setDefaultCloseOperation(0);
        }
        if (window instanceof AppFrame) {
            AppFrame appFrame = (AppFrame)window;
            int n = -1;
            for (int i = 0; i < 10; ++i) {
                if (shortcutKeyInUse[i]) continue;
                n = i;
                AppController.shortcutKeyInUse[i] = true;
                break;
            }
            appFrame.setShortcutKey(n);
            String string = appFrame.getBaseTitle();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (AppFrame appFrame2 : windowList) {
                if (!appFrame2.getBaseTitle().equals(string)) continue;
                arrayList.add(appFrame2.getTitleKey());
            }
            int n2 = appFrame.getLocation().x;
            int n3 = appFrame.getLocation().y;
            int n4 = appFrame.getTitleKey();
            if (arrayList.contains(n4)) {
                n4 = 0;
                while (arrayList.contains(n4)) {
                    ++n4;
                    n2 += 20;
                    n3 += 20;
                }
                appFrame.setTitleKey(n4);
            }
            if (appFrame.getLocationSaved()) {
                DbController.restoreWindowLocation(appFrame, appFrame.getDbID(), appFrame.getKeyTitle(), n2, n3);
            }
            windowList.add(appFrame);
            appFrame.windowWillOpen();
        } else if (window instanceof AppDialog) {
            AppDialog appDialog = (AppDialog)window;
            if (appDialog.getLocationSaved()) {
                DbController.restoreWindowLocation(appDialog, appDialog.getDbID(), appDialog.getKeyTitle(), appDialog.getLocation().x, appDialog.getLocation().y);
            }
            appDialog.windowWillOpen();
        }
        window.setVisible(true);
    }

    public static boolean hasOpenWindows() {
        return !windowList.isEmpty();
    }

    public static void hideWindow(Window window) {
        if (!window.isVisible()) {
            return;
        }
        boolean bl = false;
        window.removeWindowListener(controller);
        if (window instanceof AppFrame) {
            AppFrame appFrame = (AppFrame)window;
            if (windowList.contains(appFrame)) {
                if (appFrame.getShortcutKey() >= 0) {
                    AppController.shortcutKeyInUse[appFrame.getShortcutKey()] = false;
                }
                if (appFrame.getLocationSaved()) {
                    DbController.saveWindowLocation(appFrame, appFrame.getDbID(), appFrame.getKeyTitle());
                }
                windowList.remove(appFrame);
                if (null != currentWindow && appFrame != currentWindow) {
                    controller.updateCurrentWindowMenu();
                }
                bl = windowList.isEmpty();
            }
            appFrame.windowWillClose();
            if (appFrame.getDisposeOnClose()) {
                appFrame.dispose();
            } else {
                appFrame.setVisible(false);
            }
        } else if (window instanceof AppDialog) {
            AppDialog appDialog = (AppDialog)window;
            if (appDialog.getLocationSaved()) {
                DbController.saveWindowLocation(appDialog, appDialog.getDbID(), appDialog.getKeyTitle());
            }
            appDialog.windowWillClose();
            if (appDialog.getDisposeOnClose()) {
                appDialog.dispose();
            } else {
                appDialog.setVisible(false);
            }
        } else {
            window.setVisible(false);
        }
        if (window == currentWindow) {
            currentWindow = null;
        }
        if (isClosing) {
            return;
        }
        if (bl) {
            DbController.showLogin();
        } else if (DbController.isLoginWindow(window) && windowList.isEmpty()) {
            System.exit(0);
        }
    }

    public static boolean closeWindows() {
        for (Window window : Window.getWindows()) {
            if (!window.isVisible() || !(window instanceof Dialog) || Dialog.ModalityType.APPLICATION_MODAL != ((Dialog)window).getModalityType()) continue;
            AppController.beep();
            window.toFront();
            return false;
        }
        isClosing = true;
        while (!windowList.isEmpty()) {
            AppFrame appFrame = windowList.get(windowList.size() - 1);
            if (appFrame.closeIfPossible()) continue;
            isClosing = false;
            return false;
        }
        AppDialog appDialog = null;
        for (Window window : Window.getWindows()) {
            if (DbController.isLoginWindow(window)) {
                appDialog = (AppDialog)window;
                continue;
            }
            if (window instanceof AppDialog) {
                if (((AppDialog)window).cancel()) continue;
                isClosing = false;
                DbController.showLogin();
                return false;
            }
            AppController.hideWindow(window);
        }
        if (null != appDialog && !appDialog.cancel()) {
            isClosing = false;
            return false;
        }
        isClosing = false;
        return true;
    }

    public static void setComponentEnabled(Component component, boolean bl) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.setEditable(bl);
            if (bl) {
                jTextComponent.setBackground(Color.WHITE);
                jTextComponent.getCaret().setVisible(jTextComponent.isFocusOwner());
            } else {
                jTextComponent.setBackground(DISABLED_TEXT_BACKGROUND);
                jTextComponent.getCaret().setVisible(false);
            }
        } else if (component instanceof JTable) {
            JTable jTable = (JTable)component;
            Container container = jTable.getParent();
            jTable.setEnabled(bl);
            if (bl) {
                container.setBackground(Color.WHITE);
                jTable.setBackground(Color.WHITE);
                jTable.setGridColor(Color.WHITE);
            } else {
                container.setBackground(DISABLED_TEXT_BACKGROUND);
                jTable.setBackground(DISABLED_TEXT_BACKGROUND);
                jTable.setGridColor(DISABLED_TEXT_BACKGROUND);
            }
        } else {
            component.setEnabled(bl);
        }
    }

    public static boolean isComponentEnabled(Component component) {
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).isEditable();
        }
        return component.isEnabled();
    }

    public static void fixKeyBindings(JComponent jComponent) {
        if (null == maps) {
            maps = new int[3];
            AppController.maps[0] = 2;
            AppController.maps[1] = 0;
            AppController.maps[2] = 1;
            keys = new KeyStroke[4];
            AppController.keys[0] = KeyStroke.getKeyStroke(9, 0);
            AppController.keys[1] = KeyStroke.getKeyStroke(9, 1);
            AppController.keys[2] = KeyStroke.getKeyStroke(38, MENU_SHORTCUT_KEY_MASK);
            AppController.keys[3] = KeyStroke.getKeyStroke(40, MENU_SHORTCUT_KEY_MASK);
        }
        for (int n : maps) {
            for (InputMap inputMap = jComponent.getInputMap(n); null != inputMap; inputMap = inputMap.getParent()) {
                for (KeyStroke keyStroke : keys) {
                    inputMap.remove(keyStroke);
                }
            }
        }
        jComponent.setFocusTraversalKeys(0, null);
        jComponent.setFocusTraversalKeys(1, null);
    }

    public static void configureTable(JTable jTable) {
        AppController.configureTable(jTable, null);
    }

    public static void configureTable(JTable jTable, EditMenu editMenu) {
        jTable.setFocusable(false);
        jTable.setColumnSelectionAllowed(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        if (null != editMenu) {
            jTable.setSelectionMode(2);
            editMenu.setTargetTable(jTable);
        } else {
            jTable.setSelectionMode(0);
        }
    }

    public static JScrollPane createScrollPane(Component component) {
        return AppController.createScrollPane(component, 22, 31);
    }

    public static JScrollPane createScrollPane(Component component, int n, int n2) {
        JScrollPane jScrollPane = new JScrollPane(component, n, n2);
        if (!(component instanceof JTable)) {
            jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        }
        return jScrollPane;
    }

    public static void showPreferences() {
        if (null == prefsDialog) {
            prefsDialog = new PrefsDialog();
        }
        if (!prefsDialog.isVisible()) {
            AppController.showWindow(prefsDialog);
        } else {
            prefsDialog.toFront();
        }
    }

    public static void showHelp() {
        try {
            Desktop.getDesktop().open(AppCore.helpDirectoryPath.resolve("manual.pdf").toFile());
        }
        catch (Throwable throwable) {
            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
            AppController.showMessage("Cannot open the documentation file:\n" + throwable.getMessage(), "Documentation Not Available", 3);
        }
    }

    public static void showAbout() {
        AppController.showMessage("GUI Version " + AppCore.appVersionString + "\nEngine Version " + AppCore.engineVersionString + "\nDatabase Version " + AppCore.formatVersion((int)20300012) + "\nSupport Files " + AppCore.fileCheckID, "About TVStudy");
    }

    public static void checkInstall() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(AppCore.libDirectoryPath.resolve("check_install").toString());
        arrayList.add(AppCore.workingDirectoryPath.toString());
        RunPanelProcess runPanelProcess = new RunPanelProcess("Installation Check", arrayList);
        runPanelProcess.memoryFraction = 0.0;
        if (runPanelProcess.initialize(null)) {
            RunManager.addRunPanel(runPanelProcess);
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void showMessage(Object object, String string) {
        AppController.showMessage(null, object, string, 1);
    }

    public static void showMessage(Object object, String string, int n) {
        AppController.showMessage(null, object, string, n);
    }

    public static void showMessage(Component component, Object object, String string) {
        AppController.showMessage(component, object, string, 1);
    }

    public static void showMessage(Component component, Object object, String string, int n) {
        int n2 = 1;
        if (2 == n) {
            n2 = 2;
            AppController.beep();
        } else if (3 == n) {
            n2 = 0;
            AppController.beep();
        }
        JOptionPane.showMessageDialog(component, object, string, n2);
    }

    public static void showLongMessage(String string, String string2) {
        AppController.showLongMessage(null, string, string2, 1);
    }

    public static void showLongMessage(String string, String string2, int n) {
        AppController.showLongMessage(null, string, string2, n);
    }

    public static void showLongMessage(Component component, String string, String string2) {
        AppController.showLongMessage(component, string, string2, 1);
    }

    public static void showLongMessage(Component component, String string, String string2, int n) {
        JTextArea jTextArea = new JTextArea(15, 80);
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        AppController.setComponentEnabled(jTextArea, false);
        jTextArea.setText(string);
        AppController.showMessage(component, AppController.createScrollPane(jTextArea), string2, n);
    }

    public AppController() {
        this.doConstruct(null, null, false);
    }

    public AppController(String string, String string2, boolean bl) {
        this.doConstruct(string, string2, bl);
    }

    private void doConstruct(String string, String string2, boolean bl) {
        String string3;
        if (null != controller) {
            throw new RuntimeException("Application controller already exists");
        }
        controller = this;
        AppCore.initialize((String)System.getProperty("user.dir"), (boolean)true, (boolean)true);
        if (null != AppCore.fileCheckError) {
            AppController.showMessage(AppCore.fileCheckError + "\nPlease install the correct support files", "Installation Error", 3);
            System.exit(1);
        }
        if (null == string) {
            DbController.setDbManagerClass(StudyManager.class);
        } else {
            DbController.setDbManagerClassByName(string);
        }
        if (null == string2) {
            ShowUtilityUI = AppCore.Debug;
        } else {
            string3 = AppCore.getPreference((String)string2);
            boolean bl2 = ShowUtilityUI = null != string3 && Boolean.valueOf(string3) != false;
        }
        if (bl) {
            ShowMacOSPrefs = true;
            string3 = AppCore.getPreference((String)"useScreenMenuBar");
            if (null == string3 || Boolean.valueOf(string3).booleanValue()) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
        }
        windowList = new ArrayList();
        shortcutKeyInUse = new boolean[10];
        for (int i = 0; i < 10; ++i) {
            AppController.shortcutKeyInUse[i] = false;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (!keyEvent.isConsumed() && null != currentWindow && keyEvent.getID() == 401 && keyEvent.getModifiers() == MENU_SHORTCUT_KEY_MASK && keyEvent.getKeyCode() == 87) {
                    keyEvent.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (null != currentWindow) {
                                currentWindow.dispatchEvent(new WindowEvent(currentWindow, 201));
                            }
                        }
                    });
                    return true;
                }
                return false;
            }
        });
        ToolTipManager.sharedInstance().setDismissDelay(15000);
        JTextField jTextField = new JTextField(1);
        JPanel jPanel = new JPanel();
        jPanel.add(jTextField);
        jPanel.doLayout();
        int n = jTextField.getWidth();
        jTextField.setColumns(2);
        jPanel.doLayout();
        int n2 = jTextField.getWidth() - n;
        JLabel jLabel = new JLabel("XXXXXXXXXX");
        jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.doLayout();
        int n3 = jLabel.getWidth() / 10;
        int n4 = jLabel.getHeight();
        for (int i = 0; i <= 80; ++i) {
            AppController.textFieldWidth[i] = n + (i - 1) * n2;
            AppController.labelSize[i] = new Dimension(i * n3, n4);
        }
        DbController.showLogin();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window instanceof AppFrame && !((AppFrame)window).windowShouldClose() || window instanceof AppDialog && !((AppDialog)window).windowShouldClose()) {
            return;
        }
        AppController.hideWindow(window);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        AppController.hideWindow(windowEvent.getWindow());
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        currentWindow = windowEvent.getWindow();
        this.updateCurrentWindowMenu();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == currentWindow) {
            currentWindow = null;
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    private void updateCurrentWindowMenu() {
        if (!(currentWindow instanceof AppFrame)) {
            return;
        }
        JMenu jMenu = ((AppFrame)currentWindow).getWindowMenu();
        jMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Close Window");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != currentWindow) {
                    currentWindow.dispatchEvent(new WindowEvent(currentWindow, 201));
                }
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, MENU_SHORTCUT_KEY_MASK));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Minimize");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != currentWindow && currentWindow instanceof Frame) {
                    ((Frame)currentWindow).setExtendedState(1);
                }
            }
        });
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(77, MENU_SHORTCUT_KEY_MASK));
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Open Database...");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbController.showLogin();
            }
        });
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(76, MENU_SHORTCUT_KEY_MASK));
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        for (AppFrame appFrame : windowList) {
            JMenuItem jMenuItem4;
            if (appFrame == currentWindow) {
                jMenuItem4 = new JCheckBoxMenuItem();
                jMenuItem4.setSelected(true);
            } else {
                jMenuItem4 = new JMenuItem();
            }
            appFrame.setWindowMenuItem(jMenuItem4);
            if (appFrame.getShortcutKey() >= 0) {
                jMenuItem4.setAccelerator(KeyStroke.getKeyStroke((int)Integer.toString(appFrame.getShortcutKey()).charAt(0), MENU_SHORTCUT_KEY_MASK));
            }
            final AppFrame appFrame2 = appFrame;
            jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    appFrame2.toFront();
                }
            });
            jMenu.add(jMenuItem4);
        }
    }

    static {
        controller = null;
        maps = null;
        keys = null;
        prefsDialog = null;
    }

    private static class PrefsDialog
    extends AppDialog {
        private static final String WINDOW_TITLE = "TVStudy Preferences";
        private JComboBox<String> defaultEngineMemoryLimitMenu = new JComboBox();
        private JCheckBox autoDeletePreviousDownloadCheckBox;
        private JCheckBox ixCheckProtectPreBaselineDefaultCheckBox;
        private JCheckBox ixCheckIncludeForeignDefaultCheckBox;
        private JCheckBox ixCheckDefaultCPExcludesBLCheckBox;
        private JCheckBox ixCheckDefaultExcludeNewLPTVCheckBox;
        private JCheckBox studyManagerNameColumnFirstCheckBox;
        private JCheckBox showDbNameCheckBox;
        private JCheckBox useScreenMenuBarCheckBox;
        private Path outDirectoryPath;
        private boolean didChangeOutDirectory;
        private JLabel outDirectoryLabel;
        private JButton resetOutDirectoryButton;
        private Path cacheDirectoryPath;
        private boolean didChangeCacheDirectory;
        private JLabel cacheDirectoryLabel;
        private JButton resetCacheDirectoryButton;
        private JButton okButton;

        private PrefsDialog() {
            super(null, null, WINDOW_TITLE, Dialog.ModalityType.MODELESS);
            this.defaultEngineMemoryLimitMenu.setFocusable(false);
            this.defaultEngineMemoryLimitMenu.addItem("All");
            for (int i = 2; i <= AppCore.maxEngineProcessCount; ++i) {
                this.defaultEngineMemoryLimitMenu.addItem("1/" + String.valueOf(i));
            }
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new JLabel("   Default study engine memory use"));
            jPanel.add(this.defaultEngineMemoryLimitMenu);
            this.autoDeletePreviousDownloadCheckBox = new JCheckBox("Delete previous downloaded station data after new download");
            this.autoDeletePreviousDownloadCheckBox.setFocusable(false);
            this.ixCheckProtectPreBaselineDefaultCheckBox = new JCheckBox("IX check study: Protect records not on baseline channel");
            this.ixCheckProtectPreBaselineDefaultCheckBox.setFocusable(false);
            this.ixCheckIncludeForeignDefaultCheckBox = new JCheckBox("IX check study: Include non-U.S. stations");
            this.ixCheckIncludeForeignDefaultCheckBox.setFocusable(false);
            this.ixCheckDefaultCPExcludesBLCheckBox = new JCheckBox("IX check study: CP records exclude baseline");
            this.ixCheckDefaultCPExcludesBLCheckBox.setFocusable(false);
            this.ixCheckDefaultExcludeNewLPTVCheckBox = new JCheckBox("IX check study: Exclude new LPTV station records");
            this.ixCheckDefaultExcludeNewLPTVCheckBox.setFocusable(false);
            this.studyManagerNameColumnFirstCheckBox = new JCheckBox("Show study name column first in the study manager");
            this.studyManagerNameColumnFirstCheckBox.setFocusable(false);
            if (ShowUtilityUI) {
                this.showDbNameCheckBox = new JCheckBox("Show root database name field in login dialog");
                this.showDbNameCheckBox.setFocusable(false);
            }
            if (ShowMacOSPrefs) {
                this.useScreenMenuBarCheckBox = new JCheckBox("Show menu bar at top of screen");
                this.useScreenMenuBarCheckBox.setFocusable(false);
            }
            this.outDirectoryLabel = new JLabel("XyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXy");
            JButton jButton = new JButton("Change");
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doChangeOutDirectory();
                }
            });
            this.resetOutDirectoryButton = new JButton("Reset");
            this.resetOutDirectoryButton.setFocusable(false);
            this.resetOutDirectoryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    outDirectoryPath = null;
                    didChangeOutDirectory = true;
                    this.updateOutDirectory();
                }
            });
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(this.outDirectoryLabel);
            JPanel jPanel3 = new JPanel(new FlowLayout(0));
            jPanel3.add(jButton);
            jPanel3.add(this.resetOutDirectoryButton);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            jPanel4.setBorder(BorderFactory.createTitledBorder("Default Output Directory"));
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            this.cacheDirectoryLabel = new JLabel("XyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXy");
            JButton jButton2 = new JButton("Change");
            jButton2.setFocusable(false);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doChangeCacheDirectory();
                }
            });
            this.resetCacheDirectoryButton = new JButton("Reset");
            this.resetCacheDirectoryButton.setFocusable(false);
            this.resetCacheDirectoryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    cacheDirectoryPath = null;
                    didChangeCacheDirectory = true;
                    this.updateCacheDirectory();
                }
            });
            jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(this.cacheDirectoryLabel);
            jPanel3 = new JPanel(new FlowLayout(0));
            jPanel3.add(jButton2);
            jPanel3.add(this.resetCacheDirectoryButton);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 1));
            jPanel5.setBorder(BorderFactory.createTitledBorder("Cache Directory"));
            jPanel5.add(jPanel2);
            jPanel5.add(jPanel3);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 1));
            jPanel6.add(jPanel);
            JPanel jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(this.autoDeletePreviousDownloadCheckBox);
            jPanel6.add(jPanel7);
            jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(this.ixCheckProtectPreBaselineDefaultCheckBox);
            jPanel6.add(jPanel7);
            jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(this.ixCheckIncludeForeignDefaultCheckBox);
            jPanel6.add(jPanel7);
            jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(this.ixCheckDefaultCPExcludesBLCheckBox);
            jPanel6.add(jPanel7);
            jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(this.ixCheckDefaultExcludeNewLPTVCheckBox);
            jPanel6.add(jPanel7);
            jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(this.studyManagerNameColumnFirstCheckBox);
            jPanel6.add(jPanel7);
            if (ShowUtilityUI) {
                jPanel7 = new JPanel(new FlowLayout(0));
                jPanel7.add(this.showDbNameCheckBox);
                jPanel6.add(jPanel7);
            }
            if (ShowMacOSPrefs) {
                jPanel7 = new JPanel(new FlowLayout(0));
                jPanel7.add(this.useScreenMenuBarCheckBox);
                jPanel6.add(jPanel7);
            }
            jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(jPanel4);
            jPanel6.add(jPanel7);
            jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.add(jPanel5);
            jPanel6.add(jPanel7);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doOK();
                }
            });
            JButton jButton3 = new JButton("Cancel");
            jButton3.setFocusable(false);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.doCancel();
                }
            });
            JPanel jPanel8 = new JPanel(new FlowLayout(2));
            jPanel8.add(jButton3);
            jPanel8.add(this.okButton);
            Container container = this.getContentPane();
            container.add((Component)jPanel6, "Center");
            container.add((Component)jPanel8, "South");
            this.pack();
            this.setMinimumSize(this.getSize());
            this.setResizable(true);
            this.setLocationSaved(true);
        }

        @Override
        public String getDbID() {
            return null;
        }

        @Override
        public RootEditor getRootEditor() {
            return null;
        }

        private void doChangeOutDirectory() {
            String string = "Set Default Output Directory";
            this.errorReporter.setTitle(string);
            String string2 = null == this.outDirectoryPath ? AppCore.outDirectoryPath.toString() : this.outDirectoryPath.toString();
            JFileChooser jFileChooser = new JFileChooser(new File(string2).getParentFile());
            jFileChooser.setDialogType(1);
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            if (0 != jFileChooser.showDialog(this, "OK")) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (!file.exists()) {
                file = file.getParentFile();
            }
            if (!this.didChangeOutDirectory) {
                AppController.beep();
                AppController.showMessage(this, "This will apply only to new studies, existing studies are not affected.  The\noutput directory for an individual study can be changed in the study editor.", string, 2);
            }
            this.outDirectoryPath = file.getAbsoluteFile().toPath();
            this.didChangeOutDirectory = true;
            this.updateOutDirectory();
        }

        private void updateOutDirectory() {
            String string;
            String string2 = string = AppCore.workingDirectoryPath.resolve("out").toString();
            if (null != this.outDirectoryPath) {
                string2 = this.outDirectoryPath.toString();
            }
            this.outDirectoryLabel.setText(string2);
            this.resetOutDirectoryButton.setEnabled(!string2.equals(string));
        }

        private void doChangeCacheDirectory() {
            String string = "Set Cache Directory";
            this.errorReporter.setTitle(string);
            String string2 = null == this.cacheDirectoryPath ? AppCore.cacheDirectoryPath.toString() : this.cacheDirectoryPath.toString();
            JFileChooser jFileChooser = new JFileChooser(string2);
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            if (0 != jFileChooser.showDialog(this, "OK")) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (!file.exists()) {
                file = file.getParentFile();
            }
            if (!this.didChangeCacheDirectory) {
                AppController.beep();
                AppController.showMessage(this, "This will apply to all future study runs.  Existing cache files\nmay be deleted manually once any active runs have completed.", string, 2);
            }
            this.cacheDirectoryPath = file.getAbsoluteFile().toPath();
            this.didChangeCacheDirectory = true;
            this.updateCacheDirectory();
        }

        private void updateCacheDirectory() {
            String string;
            String string2 = string = AppCore.workingDirectoryPath.resolve("cache").toString();
            if (null != this.cacheDirectoryPath) {
                string2 = this.cacheDirectoryPath.toString();
            }
            this.cacheDirectoryLabel.setText(string2);
            this.resetCacheDirectoryButton.setEnabled(!string2.equals(string));
        }

        private void doOK() {
            AppCore.setPreference((String)"defaultEngineMemoryLimit", (String)String.valueOf(this.defaultEngineMemoryLimitMenu.getSelectedIndex()));
            AppCore.setPreference((String)"autoDeletePreviousDownload", (String)String.valueOf(this.autoDeletePreviousDownloadCheckBox.isSelected()));
            AppCore.setPreference((String)"ixCheckProtectPreBaselineDefault", (String)String.valueOf(this.ixCheckProtectPreBaselineDefaultCheckBox.isSelected()));
            AppCore.setPreference((String)"ixCheckIncludeForeignDefault", (String)String.valueOf(this.ixCheckIncludeForeignDefaultCheckBox.isSelected()));
            AppCore.setPreference((String)"ixCheckDefaultCPExcludesBL", (String)String.valueOf(this.ixCheckDefaultCPExcludesBLCheckBox.isSelected()));
            AppCore.setPreference((String)"ixCheckDefaultExcludeNewLPTV", (String)String.valueOf(this.ixCheckDefaultExcludeNewLPTVCheckBox.isSelected()));
            AppCore.setPreference((String)"studyManagerNameColumnFirst", (String)String.valueOf(this.studyManagerNameColumnFirstCheckBox.isSelected()));
            if (ShowUtilityUI) {
                AppCore.setPreference((String)"showDbName", (String)String.valueOf(this.showDbNameCheckBox.isSelected()));
            }
            if (ShowMacOSPrefs) {
                AppCore.setPreference((String)"useScreenMenuBar", (String)String.valueOf(this.useScreenMenuBarCheckBox.isSelected()));
            }
            if (this.didChangeOutDirectory) {
                AppCore.setOutDirectoryPath((Path)this.outDirectoryPath);
                this.didChangeOutDirectory = false;
            }
            if (this.didChangeCacheDirectory) {
                AppCore.setCacheDirectoryPath((Path)this.cacheDirectoryPath);
                this.didChangeCacheDirectory = false;
                StudyManager.updateCacheSizes();
            }
            if (this.windowShouldClose()) {
                AppController.hideWindow(this);
            }
        }

        private void doCancel() {
            if (this.windowShouldClose()) {
                AppController.hideWindow(this);
            }
        }

        @Override
        public void windowWillOpen() {
            String string = AppCore.getPreference((String)"defaultEngineMemoryLimit");
            if (null != string) {
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n > AppCore.maxEngineProcessCount) {
                    n = AppCore.maxEngineProcessCount;
                }
                if (n < 0) {
                    n = 0;
                }
                this.defaultEngineMemoryLimitMenu.setSelectedIndex(n);
            } else {
                this.defaultEngineMemoryLimitMenu.setSelectedIndex(0);
            }
            string = AppCore.getPreference((String)"autoDeletePreviousDownload");
            if (null != string) {
                this.autoDeletePreviousDownloadCheckBox.setSelected(Boolean.valueOf(string));
            } else {
                this.autoDeletePreviousDownloadCheckBox.setSelected(false);
            }
            string = AppCore.getPreference((String)"ixCheckProtectPreBaselineDefault");
            if (null != string) {
                this.ixCheckProtectPreBaselineDefaultCheckBox.setSelected(Boolean.valueOf(string));
            } else {
                this.ixCheckProtectPreBaselineDefaultCheckBox.setSelected(false);
            }
            string = AppCore.getPreference((String)"ixCheckIncludeForeignDefault");
            if (null != string) {
                this.ixCheckIncludeForeignDefaultCheckBox.setSelected(Boolean.valueOf(string));
            } else {
                this.ixCheckIncludeForeignDefaultCheckBox.setSelected(false);
            }
            string = AppCore.getPreference((String)"ixCheckDefaultCPExcludesBL");
            if (null != string) {
                this.ixCheckDefaultCPExcludesBLCheckBox.setSelected(Boolean.valueOf(string));
            } else {
                this.ixCheckDefaultCPExcludesBLCheckBox.setSelected(false);
            }
            string = AppCore.getPreference((String)"ixCheckDefaultExcludeNewLPTV");
            if (null != string) {
                this.ixCheckDefaultExcludeNewLPTVCheckBox.setSelected(Boolean.valueOf(string));
            } else {
                this.ixCheckDefaultExcludeNewLPTVCheckBox.setSelected(false);
            }
            string = AppCore.getPreference((String)"studyManagerNameColumnFirst");
            if (null != string) {
                this.studyManagerNameColumnFirstCheckBox.setSelected(Boolean.valueOf(string));
            } else {
                this.studyManagerNameColumnFirstCheckBox.setSelected(false);
            }
            if (ShowUtilityUI) {
                string = AppCore.getPreference((String)"showDbName");
                if (null != string) {
                    this.showDbNameCheckBox.setSelected(Boolean.valueOf(string));
                } else {
                    this.showDbNameCheckBox.setSelected(false);
                }
            }
            if (ShowMacOSPrefs) {
                string = AppCore.getPreference((String)"useScreenMenuBar");
                if (null != string) {
                    this.useScreenMenuBarCheckBox.setSelected(Boolean.valueOf(string));
                } else {
                    this.useScreenMenuBarCheckBox.setSelected(true);
                }
            }
            if (null == (string = AppCore.getPreference((String)"outDirectory"))) {
                this.outDirectoryPath = null;
            } else {
                this.outDirectoryPath = Paths.get(string, new String[0]);
                if (!this.outDirectoryPath.isAbsolute()) {
                    this.outDirectoryPath = AppCore.workingDirectoryPath.resolve(this.outDirectoryPath);
                }
            }
            this.didChangeOutDirectory = false;
            this.updateOutDirectory();
            string = AppCore.getPreference((String)"cacheDirectory");
            if (null == string) {
                this.cacheDirectoryPath = null;
            } else {
                this.cacheDirectoryPath = Paths.get(string, new String[0]);
                if (!this.cacheDirectoryPath.isAbsolute()) {
                    this.cacheDirectoryPath = AppCore.workingDirectoryPath.resolve(this.cacheDirectoryPath);
                }
            }
            this.didChangeCacheDirectory = false;
            this.updateCacheDirectory();
            this.getRootPane().setDefaultButton(this.okButton);
            this.blockActionsClear();
        }

        @Override
        public void windowWillClose() {
            this.blockActionsSet();
        }
    }
}

