#!/usr/bin/perl -w
#
# $Header: /home/bnelson/splat/unused/RCS/3xymulti.pl,v 1.3 2010-01-27 17:16:59-06 bnelson Exp $
#
# This unpublished proprietary work is Copyright (C) 2010 by
# On Air USA of Dallas, Texas, a division of SMARTS Broadcast
# Systems of Emmetsburg, Iowa, USA. All rights reserved worldwide.
#
# MODULE NAME: 3xymulti.pl
#
# AUTHOR: Bob Nelson <bnelson@onairusa.com>
#
# DATE: 27 January 2010
#
# DESCRIPTION: 
# 3xymulti.pl - combine multiple sorted splat_xy matrix files into one
# Open two input files for combining - fixed names for now. 
# Add support for command line arguments in future versions.
#
# USAGE: XXXX
#
# NOTES AND CAVEATS: XXXX

open (SITE1, "/tmp/splat_xy1.txt") or die "Can't open /tmp/splat_xy1.txt!\n";
open (SITE2, "/tmp/splat_xy2.txt") or die "Can't open /tmp/splat_xy2.txt!\n";
# Open file for writing combined data
open (MULTXY,">/tmp/multi_xy.txt") or die "Can't open /tmp/multi_xy.txt!\n";

print "Combining data from two SPLAT xy files...\n";

# Read the processed SPLAT text files 
# Get corner coordinates from site files
@corners = split /,\s/, <SITE1>;
$lonmax1 = 1200 * $corners[1];
$lonmin1 = 1200 * $corners[2];
print '  longitude 1 = '."$lonmin1".' to '."$lonmax1"."\n";
@corners = split /,\s/, <SITE1>;
$latmax1 = 1200 * $corners[1];
$latmin1 = 1200 * $corners[2];
$height1 = $ymax1 - $ymin1;
print '  latitude 1 = '."$latmin1".' to '."$latmax1"."\n";
@corners = split /,\s/, <SITE2>;
$lonmax2 = 1200 * $corners[1];
$lonmin2 = 1200 * $corners[2];
print '  longitude 2 = '."$lonmin2".' to '."$lonmax2"."\n";
@corners = split /,\s/, <SITE2>;
$latmax2 = 1200 * $corners[1];
$latmin2 = 1200 * $corners[2];
print '  latitude 2 = '."$latmin2".' to '."$latmax2"."\n";;
if (($latmax1 != $latmax2) or ($latmin1 != $latmin2) or ($lonmax1 != $lonmax2) or ($lonmin1 != $lonmin2))
  {
  print "Warning: Site areas do not match. Expanding map.\n";
  if ($latmin1 < $latmin2) {$latmin = $latmin1} else {$latmin = $latmin2};
  if ($latmax1 > $latmax2) {$latmax = $latmax1} else {$latmax = $latmax2};
  if ($lonmin1 < $lonmin2) {$lonmin = $lonmin1} else {$lonmin = $lonmin2};
  if ($lonmax1 > $lonmax2) {$lonmax = $lonmax1} else {$lonmax = $lonmax2};
  }
  else {
  $latmax = $latmax1;
  $latmin = $latmin1;
  $lonmax = $lonmax1;
  $lonmin = $lonmin1;
  };
print $latmin." ".$latmax." ".$lonmin." ".$lonmax."\n";
print MULTXY '0000000,   '.($lonmax / 1200).', '.($lonmin / 1200).'  ; max_west, min_west'."\n";
print MULTXY '0000001,   '.($latmax / 1200).', '.($latmin / 1200).'    ; max_north, min_north'."\n";

$lat = $latmin;
$lon = $lonmin;
$height = $latmax - $latmin;
$width = $lonmax - $lonmin;
print 'height = '.$height.' width = '.$width."\n";
$y = 0;
$x = 0;
$read1 = 1;
$read2 = 1;
$temp1 = "";
$fs1p = -999;
$fs2p = -999;

while ($y <= $height) {
  while ($x <= $width) {

  if ($read1) {
     $temp1 = <SITE1>;
     @data1 = split /\s/, $temp1;
     $read1 = 0;
     };
  $lat1 = $data1[0];
  $lon1 = $data1[1];
  $fs1 = $data1[2];
  if (($lat1 == $lat) && ($lon1 == $lon)) {
     $read1 = 1;
     $fs1p = $fs1;
     };

  if ($read2) {
     $temp2 = <SITE2>;
     @data2 = split /\s/, $temp2;
     $read2 = 0;
     };
  $lat2 = $data2[0];
  $lon2 = $data2[1];
  $fs2 = $data2[2];
  if (($lat2 == $lat) && ($lon2 == $lon)) {
     $read2 = 1;
     $fs2p = $fs2;
     };
  
if (($read2) | ($read1))  {
     unless ($read1) {$fs1p = -999};
     unless ($read2) {$fs2p = -999}; 
     $dataout = "$lat $lon $fs1p $fs2p";
     print MULTXY $dataout."\n";
     };
  $lon++;
  $x++;
  };
$x = 0; 
print 'Latitudes remaining '.($latmax + 1 - $lat - 1)."\n";
$lon = $lonmin;
$lat++;
$y++;
};
close SITE1;
close SITE2;
close MULTXY;
exit;
