#!/usr/bin/perl -w
#
# $Header: /home/bnelson/splat/unused/RCS/3xy2png.pl,v 1.3 2010-01-27 17:16:59-06 bnelson Exp $
#
# MODULE NAME: 3xy2png.pl
#
# AUTHOR: Bob Nelson <bnelson@onairusa.com>
#
# DATE: 27 January 2010
#
# DESCRIPTION: XXXX
#
# USAGE: XXXX
#
# NOTES AND CAVEATS: XXXX

use GD;

# Open input and output file. 
# Add support for command line arguments in future versions
open (SPLATXY, "/tmp/splat_xy.txt") or die "Can't open /tmp/splat_xy.txt!\n";
# open (TESTIMG,">xyimagtest.txt") or die "Can't open xyimagtest.txt!\n";

print "Converting SPLAT XY data to an image file....\n";

# Initialize variable
$idx = 1;
$ymax = 1200;
$ymin = 1200;
$xmax = 1200;
$xmin = 1200;
$width = 1;
$height = 1;

# Read the processed SPLAT text file, 
# Obtain the corners and size of the image from the first two lines
# Extract the latitude x 1200, longitude x 1200 and field strength date from following lines
# Convert lat/long data into Y and X coordinates and field strength into a color
# Create GDImage from X, Y and color data
while (<SPLATXY>) {
  $temp = $_;
  if ($idx > 2) {
     @data = split /\s/, $temp;
     $x = $xmax - $data[1];
     $y = $ymax - $data[0];
     $fs = $data[2];
#    print TESTIMG $data[0]." ".$data[1]." ".$data[2]." ".$x." ".$y." ".$fs." ".$temp;
     if ($fs < 41) {
       $im->setPixel($x,$y,$gray);
       }
     elsif ($fs < 48) {
       $im->setPixel($x,$y,$violet);
       }
     elsif ($fs < 58) {
       $im->setPixel($x,$y,$darkcyan);
       }
     elsif ($fs < 68) {
       $im->setPixel($x,$y,$lightcyan);
       }
     elsif ($fs < 78) {
       $im->setPixel($x,$y,$darkgreen);
       }
     elsif ($fs < 88) {
       $im->setPixel($x,$y,$green);
       }
     elsif ($fs < 93) {
       $im->setPixel($x,$y,$greenyellow);
       }
     elsif ($fs < 98) {
       $im->setPixel($x,$y,$yellow);
       }
     elsif ($fs < 103) {
       $im->setPixel($x,$y,$gold);
       }
     elsif ($fs < 108) {
       $im->setPixel($x,$y,$orange);
       }
     else {
       $im->setPixel($x,$y,$red);
       };
     }
  elsif ($idx == 1) {
     @corners = split /,\s/, $temp;
     $xmax = 1200 * $corners[1];
     $xmin = 1200 * $corners[2];
     $width = $xmax - $xmin;
     print "  width = ".$width."\n";;
     }
  else {
     @corners = split /,\s/, $temp;
     $ymax = 1200 * $corners[1];
     $ymin = 1200 * $corners[2];
     $height = $ymax - $ymin;
     print "  $height = ".$height."\n";;
#    Create blank image
     $im = new GD::Image($width, $height);
# Define colors
     $gray = $im->colorAllocate(128,128,128);
     $white = $im->colorAllocate(255,255,255);
     $black = $im->colorAllocate(0,0,0);
     $red = $im->colorAllocate(255,0,0);
     $orange = $im->colorAllocate(255,165,0);
     $gold = $im->colorAllocate(255,206,0);
     $yellow = $im->colorAllocate(255,255,0);
     $greenyellow = $im->colorAllocate(184,255,0);
     $green = $im->colorAllocate(0,255,0);
     $darkgreen = $im->colorAllocate(0,208,0);
     $lightcyan = $im->colorAllocate(0,196,196);
     $darkcyan = $im->colorAllocate(0,148,255);
     $violet = $im->colorAllocate(80,80,255);
#     $im->transparent($white);
     };
  $idx++;
};
# Close input file
close SPLATXY;

# Display status information
print $idx." records processed.\n";
print 'xmin = '.$xmin.'  xmax = '.$xmax.'  ymin = '.$ymin.'  ymax = '.$ymax."\n";
print 'height = '.$height.'  width = '.$width."\n";

#Write PNG image file
$pngdata = $im->png(6);
open (PNGPLOT,">pngplot.png") or die "Can't open pngplot.png!\n";
binmode PNGPLOT;
print PNGPLOT $pngdata;
close PNGPLOT;

#Write KML file
open (KMLFILE,">pngplot.kml") or die "Can't open pngplot.kml!\n";
print KMLFILE '<?xml version="1.0" encoding="UTF-8"?>'."\n";
print KMLFILE '<kml xmlns="http://www.opengis.net/kml/2.2">'."\n";
print KMLFILE '  <Folder>'."\n";
print KMLFILE '    <name>SPLAT!</name>'."\n";
print KMLFILE '    <description>Longley-Rice signal and interference map</description>'."\n";
print KMLFILE '    <GroundOverlay>'."\n";
print KMLFILE '      <name>SPLAT! Signal Strength Overlay</name>'."\n";
print KMLFILE '      <Icon>'."\n";
print KMLFILE '        <href>pngplot.png</href>'."\n";
print KMLFILE '      </Icon>'."\n";
print KMLFILE '      <LatLonBox>'."\n";
print KMLFILE '        <north>'.(($ymax) / 1200).'</north>'."\n";
print KMLFILE '        <south>'.(($ymin) / 1200).'</south>'."\n";
print KMLFILE '        <east>'.-(($xmax) / 1200).'</east>'."\n";
print KMLFILE '        <west>'.-(($xmin) / 1200).'</west>'."\n";
print KMLFILE '        <rotation>-0.000000</rotation>'."\n";
print KMLFILE '      </LatLonBox>'."\n";
print KMLFILE '    </GroundOverlay>'."\n";
print KMLFILE '  </Folder>'."\n";
print KMLFILE '</kml>'."\n";
close KMLFILE;

# close TESTIMG;
