#!/usr/bin/perl -w
#
# $Header: /home/bnelson/splat/unused/RCS/3xy2png-multi-diff.pl,v 1.3 2010-01-27 17:16:59-06 bnelson Exp $
#
# MODULE NAME: 3xy2png-multi-diff.pl
#
# AUTHOR: Bob Nelson <bnelson@onairusa.com>
#
# DATE: 27 January 2010
#
# DESCRIPTION: XXXX
#
# USAGE: XXXX
#
# NOTES AND CAVEATS: XXXX

use GD;

# Open input and output file. 
# Add support for command line arguments in future versions
open (MULTXY, "/tmp/multi_xy.txt") or die "Can't open /tmp/multi_xy.txt!\n"; 
# open (TESTIMG,">xyimagtest.txt") or die "Can't open xyimagtest.txt!\n";

print "Converting SPLAT Multi XY data to an image file....\n";

# Initialize variable
$idx = 1;
$ymax = 1200;
$ymin = 1200;
$xmax = 1200;
$xmin = 1200;
$width = 1;
$height = 1;
$count = 0;

# Read the processed SPLAT text file, 
# Obtain the corners and size of the image from the first two lines
# Extract the latitude x 1200, longitude x 1200 and field strength date from following lines
# Convert lat/long data into Y and X coordinates and field strength into a color
# Create GDImage from X, Y and color data
while (<MULTXY>) {
  $temp = $_;
  if ($idx > 2) {
     @data = split /\s/, $temp;
     $x = $xmax - $data[1];
     $y = $ymax - $data[0];
     $fs1 = $data[2];
     $fs2 = $data[3];

#     print TESTIMG $data[0]." ".$data[1]." ".$data[2]." ".$x." ".$y." ".$fs." ".$temp;
     if (($fs1 < 41) && ($fs2 < 41)) {
#     if ($fs1 < 41) {
       $im->setPixel($x,$y,$gray);
       }
     elsif (($fs1 >= 41) && ($fs1 > $fs2 + 15)) {
       $im->setPixel($x,$y,$cyan);
       }
     elsif (($fs1 < $fs2 - 15) && ($fs2 >= 41)) {
       $im->setPixel($x,$y,$pink);
       }
     else {
       $im->setPixel($x,$y,$lightorange);
       };
     }
  elsif ($idx == 1) {
     @corners = split /,\s/, $temp;
     $xmax = 1200 * $corners[1];
     $xmin = 1200 * $corners[2];
     $width = $xmax - $xmin;
     print "  width = ".$width."\n";
     }
  else {
     @corners = split /,\s/, $temp;
     $ymax = 1200 * $corners[1];
     $ymin = 1200 * $corners[2];
     $height = $ymax - $ymin;
     print "  height = ".$height."\n";
#    Create blank image
     $im = new GD::Image($width, $height);
# Define colors
     $gray = $im->colorAllocate(128,128,128);
     $white = $im->colorAllocate(255,255,255);
     $black = $im->colorAllocate(0,0,0);
     $red = $im->colorAllocate(255,0,0);
     $threshold = $im->colorAllocate(255,0,0);
     $dbu103 = $im->colorAllocate(255,165,0);
     $dbu98 = $im->colorAllocate(255,206,0);
     $outdoor = $im->colorAllocate(255,165,0);
     $dbu93 = $im->colorAllocate(255,255,0);
     $easyoutdoor = $im->colorAllocate(255,255,0);
     $dbu88 = $im->colorAllocate(184,255,0);
     $verygood = $im->colorAllocate(184,255,0);
     $dbu78 = $im->colorAllocate(0,255,0);
     $indoor = $im->colorAllocate(0,255,0);
     $dbu68 = $im->colorAllocate(0,208,0);
     $dbu58 = $im->colorAllocate(0,196,196);
     $dbu48 = $im->colorAllocate(0,148,255);
     $dbu41 = $im->colorAllocate(80,80,255);
     $purple = $im->colorAllocate(128,0, 255);
     $pink = $im->colorAllocate(255,128,128);
     $cyan = $im->colorAllocate(128,255,255);
     $lightorange = $im->colorAllocate(253,190,43);

#     $im->transparent($white);
     };
  $idx++;
  $count++;
  if ($count == $height*50) {
    print '+';
    $count = 0;
    };
};
# Close input file
close SPLATXY;

# Display status information
print "\n";
print $idx." records processed.\n";
print 'xmin = '.$xmin.'  xmax = '.$xmax.'  ymin = '.$ymin.'  ymax = '.$ymax."\n";
print 'height = '.$height.'  width = '.$width."\n";

#Write PNG image file
$pngdata = $im->png(6);
open (PNGPLOT,">pngplot.png") or die "Can't open pngplot.png!\n";
binmode PNGPLOT;
print PNGPLOT $pngdata;
close PNGPLOT;

#Write KML file
open (KMLFILE,">pngplot.kml") or die "Can't open pngplot.kml!\n";
print KMLFILE '<?xml version="1.0" encoding="UTF-8"?>'."\n";
print KMLFILE '<kml xmlns="http://www.opengis.net/kml/2.2">'."\n";
print KMLFILE '  <Folder>'."\n";
print KMLFILE '    <name>SPLAT!</name>'."\n";
print KMLFILE '    <description>Longley-Rice signal and interference map</description>'."\n";
print KMLFILE '    <GroundOverlay>'."\n";
print KMLFILE '      <name>SPLAT! Signal Strength Overlay</name>'."\n";
print KMLFILE '      <Icon>'."\n";
print KMLFILE '        <href>pngplot.png</href>'."\n";
print KMLFILE '      </Icon>'."\n";
print KMLFILE '      <LatLonBox>'."\n";
print KMLFILE '        <north>'.(($ymax) / 1200).'</north>'."\n";
print KMLFILE '        <south>'.(($ymin) / 1200).'</south>'."\n";
print KMLFILE '        <east>'.-(($xmax) / 1200).'</east>'."\n";
print KMLFILE '        <west>'.-(($xmin) / 1200).'</west>'."\n";
print KMLFILE '        <rotation>-0.000000</rotation>'."\n";
print KMLFILE '      </LatLonBox>'."\n";
print KMLFILE '    </GroundOverlay>'."\n";
print KMLFILE '  </Folder>'."\n";
print KMLFILE '</kml>'."\n";
close KMLFILE;

# close TESTIMG;
