#!/usr/bin/perl
#
# $Header: /home/bnelson/splat/RCS/sp3gridproc.pl,v 1.14 2010-01-27 22:17:55-06 bnelson Exp $
#
# MODULE NAME: sp3gridproc.pl
#
# AUTHOR: Bob Nelson <bnelson@onairusa.com>
#
# DATE: 27 January 2010
#
# DESCRIPTION: XXXX
#
# USAGE: XXXX
#
# NOTES AND CAVEATS: XXXX

use Math::Round;
use strict;

use vars qw(*SPLATDAT *SPLATXY *SITE *CLEAN);

open SPLATDAT, "/tmp/splat_data.txt" or die "Can't open /tmp/splat_data.txt, $!\n";
open SPLATXY,">/tmp/splat_xy.txt" or die "Can't open /tmp/splat_xy.txt, $!\n";

print "Rounding coordinates to 3 second intervals...\n";
my $idx = 1;

while(<SPLATDAT>) {
    my $line = $_;
    my @splatline = split /,\s/, $line;

    $splatline[0] = round($splatline[0] * 1200);
    $splatline[1] = round($splatline[1] * 1200);
    $splatline[4] =~ s/\s.//;

    if($idx > 2) {
        $line = "$splatline[0] $splatline[1] $splatline[4]";
    }
    elsif($idx == 1) {
        $line = "0000000,  $_";
    }
    else {
        $line = "0000001,  $_";
    }

    print SPLATXY $line;
    $idx++;
}

print $idx." records processed.\n";

close SPLATDAT;
unlink "/tmp/splat_data.txt";

close SPLATXY;

print "Sorting SPLAT xy file...\n";
system "sort /tmp/splat_xy.txt > /tmp/sorted_splat_xy.txt";

open SITE, "/tmp/sorted_splat_xy.txt" or die "Can't open /tmp/splat_xy.txt, $!\n";
open CLEAN, "> /tmp/clean_xy.txt" or die "Can't open /tmp/clean_xy.txt, $!\n";

print "Cleaning duplicates from sorted SPLAT xy file...\n";

# Read the processed SPLAT text files
# Get corner coordinates from site files
my @corners = split /,\s/, <SITE>;
my $lonmax1 = 1200 * $corners[1];
my $lonmin1 = 1200 * $corners[2];
print '  longitude 1 = '."$lonmin1".' to '."$lonmax1"."\n";

@corners = split /,\s/, <SITE>;
my $latmax1 = 1200 * $corners[1];
my $latmin1 = 1200 * $corners[2];

print '  latitude 1 = '."$latmin1".' to '."$latmax1"."\n";
print CLEAN '0000000,   '.($lonmax1 / 1200).', '.($lonmin1 / 1200).'  ; max_west, min_west'."\n";
print CLEAN '0000001,   '.($latmax1 / 1200).', '.($latmin1 / 1200).'    ; max_north, min_north'."\n";

my $oldlon = 0;
my $oldlat = 0;
my $duplicate = 0;

while(<SITE>) {
    my $temp = $_;
    my @data = split /\s/, $temp;
    my $lat = $data[0];
    my $lon = $data[1];
    my $fs = $data[2];
    my $lonpr;
    my $noprint;
    my $datatemp;

    if(($lon == $oldlon) && ($lat == $oldlat)) {
        $lonpr = $lon + 1;
        $datatemp = "$lat $lonpr $fs";
        $noprint = 1;
    }
    elsif(($lon == ($oldlon + 1)) && ($oldlat == $lat)) {
        $noprint = 0;
        $datatemp = "";
    }
    elsif(($lon == ($oldlon + 2)) && ($oldlat == $lat)) {
        if($datatemp) {
            print CLEAN $datatemp."\n";
        }
        $datatemp = "";
        $noprint = 0;
        $duplicate = $duplicate + 1;
    }
    else {
        $noprint = 0;
    }

    my $dataout = "$lat $lon $fs";

    $oldlon = $lon;
    $oldlat = $lat;
    unless($noprint) {
        print CLEAN $dataout."\n";
    }
}

close SITE;
unlink "/tmp/sorted_splat_xy.txt";

close CLEAN;

exit 0;
