#!/usr/bin/perl
#
# $Header: /home/bnelson/splat/RCS/3xy2png-rx-colors.pl,v 1.9 2010-01-27 22:17:55-06 bnelson Exp $
#
# MODULE NAME: 3xy2png-rx-colors.pl
#
# AUTHOR: Doug Lung <dlung@transmitter.com>
#
# MODIFIED BY: Bob Nelson <bnelson@onairusa.com>
#
# DATE: 27 January 2010
#
# DESCRIPTION: XXXX
#
# USAGE: XXXX
#
# NOTES AND CAVEATS: XXXX

use GD;
use strict;

# Open input and output file.
# Add support for command line arguments in future versions

open SPLATXY, "/tmp/splat_xy.txt" or die "Can't open /tmp/splat_xy.txt!\n";

print "Converting SPLAT XY data to image file\n";

# Initialize variables:
my $idx = 1;
my $ymax = 1200;
my $ymin = 1200;
my $xmax = 1200;
my $xmin = 1200;
my $width = 1;
my $height = 1;
my ($im, $gray, $threshold, $outdoor, $easyoutdoor, $verygood, $indoor) =
   ('', '', '', '', '', '', '');

# Read the processed SPLAT text file,
# Obtain the corners and size of the image from the first two lines
# Extract the latitude x 1200, longitude x 1200 and field strength date from following lines
# Convert lat/long data into Y and X coordinates and field strength into a color
# Create GDImage from X, Y and color data

while(<SPLATXY>) {
    if($idx > 2) {
        my @data = split /\s/, $_;
        my $x = $xmax - $data[1];
        my $y = $ymax - $data[0];
        my $fs = $data[2];

        if ($fs < 41) {
            $im->setPixel($x,$y,$gray);
        }
        elsif ($fs < 51) {
            $im->setPixel($x,$y,$threshold);
        }
        elsif ($fs < 61) {
            $im->setPixel($x,$y,$outdoor);
        }
        elsif ($fs < 71) {
            $im->setPixel($x,$y,$easyoutdoor);
        }
        elsif ($fs < 81) {
            $im->setPixel($x,$y,$verygood);
        }
        else {
            $im->setPixel($x,$y,$indoor);
        }
    }
    elsif($idx == 1) {
        my @corners = split /,\s/, $_;

        $xmax = 1200 * $corners[1];
        $xmin = 1200 * $corners[2];
        $width = $xmax - $xmin;

        print "  width = ".$width."\n";;
    }
    else {
        my @corners = split /,\s/, $_;

        $ymax = 1200 * $corners[1];
        $ymin = 1200 * $corners[2];
        $height = $ymax - $ymin;

        print "  $height = ".$height."\n";

        # Create blank image
        $im = new GD::Image($width, $height);

        # Define colors
        $gray = $im->colorAllocate(128,128,128);
        $threshold = $im->colorAllocate(255,0,0);
        $outdoor = $im->colorAllocate(255,165,0);
        $easyoutdoor = $im->colorAllocate(255,255,0);
        $verygood = $im->colorAllocate(184,255,0);
        $indoor = $im->colorAllocate(0,255,0);
    }

    $idx++;
}

close SPLATXY;

# Display status information
print $idx." records processed.\n";
print 'xmin = '.$xmin.'  xmax = '.$xmax.'  ymin = '.$ymin.'  ymax = '.$ymax."\n";
print 'height = '.$height.'  width = '.$width."\n";

# Write PNG image file:
my $pngdata = $im->png(6);
open PNGPLOT,"> pngplot.png" or die "Can't open pngplot.png, $!\n";
binmode PNGPLOT;
print PNGPLOT $pngdata;
close PNGPLOT;

# Write KML file:
open  KMLFILE,">pngplot.kml" or die "Can't open pngplot.kml, $!\n";
print KMLFILE '<?xml version="1.0" encoding="UTF-8"?>'."\n";
print KMLFILE '<kml xmlns="http://www.opengis.net/kml/2.2">'."\n";
print KMLFILE '  <Folder>'."\n";
print KMLFILE '    <name>SPLAT!</name>'."\n";
print KMLFILE '    <description>Longley-Rice signal and interference map</description>'."\n";
print KMLFILE '    <GroundOverlay>'."\n";
print KMLFILE '      <name>SPLAT! Signal Strength Overlay</name>'."\n";
print KMLFILE '      <Icon>'."\n";
print KMLFILE '        <href>pngplot.png</href>'."\n";
print KMLFILE '      </Icon>'."\n";
print KMLFILE '      <LatLonBox>'."\n";
print KMLFILE '        <north>'.(($ymax) / 1200).'</north>'."\n";
print KMLFILE '        <south>'.(($ymin) / 1200).'</south>'."\n";
print KMLFILE '        <east>'.-(($xmax) / 1200).'</east>'."\n";
print KMLFILE '        <west>'.-(($xmin) / 1200).'</west>'."\n";
print KMLFILE '        <rotation>-0.000000</rotation>'."\n";
print KMLFILE '      </LatLonBox>'."\n";
print KMLFILE '    </GroundOverlay>'."\n";
print KMLFILE '  </Folder>'."\n";
print KMLFILE '</kml>'."\n";
close KMLFILE;

print "Wrote KML file, now writing text file for RabbitEars.\n";

open TXTFILE,">/tmp/pngplot.txt" or die "Can't open /tmp/pngplot.txt, $!\n";
print TXTFILE 'new GLatLng('.(($ymin) / 1200).','.-(($xmax) / 1200).'), new GLatLng('.(($ymax) / 1200).','.-(($xmin) / 1200).')';
close TXTFILE;

exit 0;
